/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import com.google.sitebricks.headless.Reply;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class ExecuteValid<T> extends Execute<T> {

  private final T pojo;

  public ExecuteValid(UploadCtx ctx, T pojo) {
    super(ctx);
    this.pojo = pojo;
  }

  @Override
  public RedirectWith<T> redirectWith(UploadRedirect<T> redirect) {
    UploadRedirector redirector = ctx.getRedirector();
    String url = redirect.onSuccess(redirector, pojo);
    return new RedirectWithValid<T>(ctx, url, pojo);
  }

  @Override
  public Reply<?> reply() {
    return Reply.saying().ok();
  }

  @Override
  public Reply<?> replyWith(UploadReplier<T> replier) {
    return replier.onSuccess(pojo);
  }

  @Override
  T getPojo() {
    return pojo;
  }

}