/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.io.File;

import br.com.objectos.comuns.web.upload.UploadedFile;

import com.google.common.io.Files;
import com.google.inject.Inject;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class FirstFromRequestValid extends FirstFromRequest {

  private final UploadedFile uploadedFile;

  @Inject
  public FirstFromRequestValid(UploadCtx ctx, UploadedFile uploadedFile) {
    super(ctx);
    this.uploadedFile = uploadedFile;
  }

  @Override
  public AndSaveTo andSaveToDir(File dir) {
    return AndSaveTo.executeDir(ctx, uploadedFile, dir);
  }

  @Override
  public AndSaveTo andSaveToFile(File file) {
    return AndSaveTo.executeFile(ctx, uploadedFile, file);
  }

  @Override
  public <T> Execute<T> execute(UploadSingleAction<T> action) {
    File dir = Files.createTempDir();
    return andSaveToDir(dir).execute(action);
  }

  @Override
  UploadedFile getUploadedFile() {
    return uploadedFile;
  }

}