/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import static com.google.common.collect.Lists.transform;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class UploadError {

  private static final Logger logger = LoggerFactory.getLogger(UploadError.class);

  private final List<String> messages;

  private final List<Exception> exceptions;

  private UploadError(List<String> messages, List<Exception> exceptions) {
    this.messages = messages;
    this.exceptions = exceptions;
  }

  public static UploadError of(List<Exception> exceptions) {
    List<String> _messages = transform(exceptions, new ToMessage());
    List<String> messages = ImmutableList.copyOf(_messages);
    return new UploadError(messages, exceptions);
  }

  public List<String> getMessages() {
    return messages;
  }

  public List<Exception> getExceptions() {
    return exceptions;
  }

  private static class ToMessage implements Function<Exception, String> {
    @Override
    public String apply(Exception e) {
      String message = e.getMessage();
      return Strings.nullToEmpty(message);
    }
  }

  public void logExceptions() {
    for (Exception e : exceptions) {
      logger.error("Could not process uploaded file", e);
    }
  }

}