/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.ui.server;

import java.io.IOException;

import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class ApacheSslConnector extends SelectChannelConnector {

  @Override
  public void customize(EndPoint endpoint, Request request) throws IOException {
    super.customize(endpoint, request);
    if ("https".equals(request.getHeader("X-Forwarded-Proto"))) {
      request.setScheme("https");
    }
  }

}