/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.maven;

import br.com.softplan.security.zap.api.ZapClient;
import br.com.softplan.security.zap.api.model.AnalysisInfo;
import br.com.softplan.security.zap.api.model.AnalysisType;
import br.com.softplan.security.zap.api.model.AuthenticationInfo;
import br.com.softplan.security.zap.api.report.ZapReport;
import br.com.softplan.security.zap.commons.ZapInfo;
import br.com.softplan.security.zap.commons.boot.Zap;
import br.com.softplan.security.zap.maven.ZapMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="seleniumAnalyze")
public class SeleniumAnalyzeMojo
extends ZapMojo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Starting ZAP analysis at target: " + super.getTargetUrl()));
        ZapInfo zapInfo = this.buildZapInfo();
        AuthenticationInfo authenticationInfo = this.buildAuthenticationInfo();
        AnalysisInfo analysisInfo = this.buildAnalysisInfo(AnalysisType.ACTIVE_SCAN_ONLY);
        ZapClient zapClient = new ZapClient(zapInfo, authenticationInfo);
        try {
            ZapReport zapReport = zapClient.analyze(analysisInfo);
            this.saveReport(zapReport);
        }
        finally {
            Zap.stopZap();
        }
        this.getLog().info((CharSequence)"ZAP analysis finished.");
    }
}

