/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.maven;

import br.com.softplan.security.zap.api.model.AnalysisInfo;
import br.com.softplan.security.zap.api.model.AnalysisType;
import br.com.softplan.security.zap.api.model.AuthenticationInfo;
import br.com.softplan.security.zap.api.model.SeleniumDriver;
import br.com.softplan.security.zap.api.report.ZapReport;
import br.com.softplan.security.zap.api.report.ZapReportUtil;
import br.com.softplan.security.zap.commons.ZapInfo;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class ZapMojo
extends AbstractMojo {
    @Parameter(property="zap.skip", defaultValue="false")
    private boolean skip;
    @Parameter(required=true)
    private String targetUrl;
    @Parameter
    private String spiderStartingPointUrl;
    @Parameter
    private String activeScanStartingPointUrl;
    @Parameter
    private String[] context;
    @Parameter
    private String[] technologies;
    @Parameter(defaultValue="480")
    private int analysisTimeoutInMinutes;
    @Parameter(defaultValue="false")
    private boolean shouldRunAjaxSpider;
    @Parameter(defaultValue="false")
    private boolean shouldRunPassiveScanOnly;
    @Parameter(defaultValue="true")
    private boolean shouldStartNewSession;
    @Parameter(required=true)
    private Integer zapPort;
    @Parameter(defaultValue="localhost")
    private String zapHost;
    @Parameter(defaultValue="")
    private String zapApiKey;
    @Parameter
    private String zapPath;
    @Parameter(defaultValue="-Xmx512m")
    private String zapJvmOptions;
    @Parameter(defaultValue="-daemon -config api.disablekey=true -config api.incerrordetails=true -config proxy.ip=0.0.0.0")
    private String zapOptions;
    @Parameter(defaultValue="false")
    private boolean shouldRunWithDocker;
    @Parameter(defaultValue="120000")
    private Integer initializationTimeoutInMillis;
    @Parameter(defaultValue="${project.build.directory}/zap-reports")
    private File reportPath;
    @Parameter
    private String authenticationType;
    @Parameter
    private String loginUrl;
    @Parameter
    private String username;
    @Parameter
    private String password;
    @Parameter
    private String extraPostData;
    @Parameter
    private String loggedInRegex;
    @Parameter
    private String loggedOutRegex;
    @Parameter
    private String[] excludeFromScan;
    @Parameter
    private String[] protectedPages;
    @Parameter(defaultValue="username")
    private String usernameParameter;
    @Parameter(defaultValue="password")
    private String passwordParameter;
    @Parameter
    private String[] httpSessionTokens;
    @Parameter(defaultValue="firefox")
    private String seleniumDriver;
    @Parameter
    private String hostname;
    @Parameter
    private String realm;
    @Parameter(defaultValue="80")
    private int port;

    protected ZapInfo buildZapInfo() {
        return ZapInfo.builder().host(this.zapHost).port(this.zapPort.intValue()).apiKey(this.zapApiKey).path(this.zapPath).jmvOptions(this.zapJvmOptions).options(this.zapOptions).initializationTimeoutInMillis(Long.valueOf(this.initializationTimeoutInMillis.intValue())).shouldRunWithDocker(this.shouldRunWithDocker).build();
    }

    protected AuthenticationInfo buildAuthenticationInfo() {
        if (this.authenticationType == null) {
            return null;
        }
        return AuthenticationInfo.builder().type(this.authenticationType).loginUrl(this.loginUrl).username(this.username).password(this.password).extraPostData(this.extraPostData).loggedInRegex(this.loggedInRegex).loggedOutRegex(this.loggedOutRegex).excludeFromScan(this.excludeFromScan).protectedPages(this.protectedPages).usernameParameter(this.usernameParameter).passwordParameter(this.passwordParameter).loginRequestData().httpSessionTokens(this.httpSessionTokens).seleniumDriver(SeleniumDriver.valueOf((String)this.seleniumDriver.toUpperCase())).hostname(this.hostname).realm(this.realm).port(this.port).build();
    }

    protected AnalysisInfo buildAnalysisInfo() {
        AnalysisType analysisType = AnalysisType.WITH_SPIDER;
        if (this.shouldRunAjaxSpider && this.shouldRunPassiveScanOnly) {
            analysisType = AnalysisType.SPIDER_AND_AJAX_SPIDER_ONLY;
        } else {
            if (this.shouldRunAjaxSpider) {
                analysisType = AnalysisType.WITH_AJAX_SPIDER;
            }
            if (this.shouldRunPassiveScanOnly) {
                analysisType = AnalysisType.SPIDER_ONLY;
            }
        }
        return this.buildAnalysisInfo(analysisType);
    }

    protected AnalysisInfo buildAnalysisInfo(AnalysisType analysisType) {
        return AnalysisInfo.builder().targetUrl(this.targetUrl).spiderStartingPointUrl(this.spiderStartingPointUrl).activeScanStartingPointUrl(this.activeScanStartingPointUrl).context(this.context).technologies(this.technologies).analysisTimeoutInMinutes((long)this.analysisTimeoutInMinutes).analysisType(analysisType).shouldStartNewSession(this.shouldStartNewSession).build();
    }

    protected void saveReport(ZapReport zapReport) {
        this.getLog().info((CharSequence)"Saving Reports...");
        if (this.reportPath != null) {
            ZapReportUtil.saveAllReports((ZapReport)zapReport, (String)this.reportPath.getAbsolutePath());
        } else {
            ZapReportUtil.saveAllReports((ZapReport)zapReport);
        }
    }

    protected String getTargetUrl() {
        return this.targetUrl;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Zap is skipped.");
            return;
        }
        this.doExecute();
    }

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;
}

