/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.ArrayList;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

abstract class BaseService {
    private static final Integer FALSE_IN_PHP = 0;
    private XmlRpcClient xmlRpcClient;
    private String devKey;

    BaseService(XmlRpcClient xmlRpcClient, String devKey) {
        this.xmlRpcClient = xmlRpcClient;
        this.devKey = devKey;
    }

    public Object executeXmlRpcCall(String methodName, Map<String, Object> executionData) throws XmlRpcException, TestLinkAPIException {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
        if (executionData != null) {
            if (executionData.get(TestLinkParams.DEV_KEY.toString()) == null) {
                executionData.put(TestLinkParams.DEV_KEY.toString(), this.devKey);
            }
            params.add(executionData);
        }
        Object o = this.xmlRpcClient.execute(methodName, params);
        this.checkResponseError(o);
        return o;
    }

    protected void checkResponseError(Object response) throws TestLinkAPIException {
        if (response instanceof Object[]) {
            Object[] responseArray = Util.castToArray(response);
            for (int i = 0; i < responseArray.length; ++i) {
                Object maybeAMap = responseArray[i];
                if (!(maybeAMap instanceof Map)) continue;
                Map errorMap = (Map)maybeAMap;
                Integer code = Util.getInteger(errorMap, "code");
                String message = Util.getString(errorMap, "message");
                if (code == null) continue;
                throw new TestLinkAPIException(code, message);
            }
        } else if (response instanceof Map) {
            Map errorMap = (Map)response;
            Integer statusOk = Util.getInteger(errorMap, "status_ok");
            String message = Util.getString(errorMap, "msg");
            if (statusOk != null && statusOk.equals(FALSE_IN_PHP)) {
                throw new TestLinkAPIException(statusOk, message);
            }
        }
    }
}

