/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

class BuildService
extends BaseService {
    BuildService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected Build createBuild(Integer testPlanId, String buildName, String buildNotes) throws TestLinkAPIException {
        Build build = null;
        Integer id = 0;
        build = new Build(id, testPlanId, buildName, buildNotes);
        try {
            Map<String, Object> executionData = Util.getBuildMap(build);
            Object response = this.executeXmlRpcCall(TestLinkMethods.CREATE_BUILD.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            build.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error creating build: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return build;
    }

    protected Build[] getBuildsForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        Build[] builds = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_BUILDS_FOR_TEST_PLAN.toString(), executionData);
            if (response instanceof Object[]) {
                Object[] responseArray = Util.castToArray(response);
                builds = new Build[responseArray.length];
                for (int i = 0; i < responseArray.length; ++i) {
                    Map responseMap = (Map)responseArray[i];
                    builds[i] = Util.getBuild(responseMap);
                }
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving test plan's builds: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return builds;
    }

    protected Build getLatestBuildForTestPlan(Integer testPlanId) throws TestLinkAPIException {
        Build build = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_LATEST_BUILD_FOR_TEST_PLAN.toString(), executionData);
            if (response instanceof Map) {
                Map responseMap = (Map)response;
                build = Util.getBuild(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving latest build for test plan: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return build;
    }

    protected Map<String, Object> getExecCountersByBuild(Integer testPlanId) {
        Map responseMap = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_EXEC_COUNTERS_BY_BUILD.toString(), executionData);
            if (response instanceof Map) {
                responseMap = (Map)response;
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error getting exec counters by build: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return responseMap;
    }

    protected Map<String, Object> updateBuildCustomFields(Integer buildId, Integer testProjectId, Integer testPlanId, Map<String, String> customFields) {
        Map<String, Object> responseMap = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.BUILD_ID.toString(), buildId);
            executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testProjectId);
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            executionData.put(TestLinkParams.CUSTOM_FIELDS.toString(), customFields);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPDATE_BUILD_CUSTOM_FIELDS.toString(), executionData);
            if (response instanceof Map) {
                responseMap = Util.castToMap(response);
            } else if (!(response instanceof String)) {
                responseMap = Util.castToMap(((Object[])response)[0]);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error updating Build custom fields. " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return responseMap;
    }
}

