/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkTables;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

class ReqSpecService
extends BaseService {
    ReqSpecService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected Attachment uploadRequirementSpecificationAttachment(Integer reqSpecId, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Attachment attachment = null;
        Integer id = 0;
        attachment = new Attachment(id, reqSpecId, TestLinkTables.REQUIREMENT_SPECIFICATIONS.toString(), title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getRequirementSpecificationAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPLOAD_REQUIREMENT_SPECIFICATION_ATTACHMENT.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment for requirement specification: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }
}

