/*
 * Decompiled with CFR 0.152.
 */
package build.buf.gradle;

import build.buf.gradle.BufExtension;
import build.buf.gradle.ExtensionSupportKt;
import build.buf.gradle.GradleSupportKt;
import build.buf.gradle.OutputSupportKt;
import build.buf.gradle.ProcessRunner;
import build.buf.gradle.ProtobufGradlePluginSupportKt;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a=\u0010\u0005\u001a\u00020\u0003*\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\u0010\f\u001a2\u0010\u0005\u001a\u00020\u0003*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"BUF_BINARY_CONFIGURATION_NAME", "", "configureBufDependency", "", "Lorg/gradle/api/Project;", "execBuf", "Lorg/gradle/api/Task;", "args", "", "", "customErrorMessage", "Lkotlin/Function1;", "(Lorg/gradle/api/Task;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "", "buf-gradle-plugin"})
public final class BufSupportKt {
    @NotNull
    public static final String BUF_BINARY_CONFIGURATION_NAME = "bufTool";

    public static final void configureBufDependency(@NotNull Project $this$configureBufDependency) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$configureBufDependency, (String)"$this$configureBufDependency");
        String string3 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"System.getProperty(\"os.name\")");
        String string4 = string3;
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase()");
        String os = string5;
        if (StringsKt.startsWith$default((String)os, (String)"windows", (boolean)false, (int)2, null)) {
            string2 = "windows";
        } else if (StringsKt.startsWith$default((String)os, (String)"linux", (boolean)false, (int)2, null)) {
            string2 = "linux";
        } else if (StringsKt.startsWith$default((String)os, (String)"mac", (boolean)false, (int)2, null)) {
            string2 = "osx";
        } else {
            String string6 = "unsupported os: " + os;
            throw new IllegalStateException(string6.toString());
        }
        String osPart = string2;
        String string7 = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"System.getProperty(\"os.arch\")");
        String string8 = string7;
        String string9 = string8.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase()");
        String arch = string9;
        if (SetsKt.setOf((Object[])new String[]{"x86_64", "amd64"}).contains(arch)) {
            string = "x86_64";
        } else if (SetsKt.setOf((Object[])new String[]{"arm64", "aarch64"}).contains(arch)) {
            string = "aarch_64";
        } else {
            string8 = "unsupported arch: " + arch;
            throw new IllegalStateException(string8.toString());
        }
        String archPart = string;
        BufExtension extension = ExtensionSupportKt.getExtension($this$configureBufDependency);
        GradleSupportKt.createConfigurationWithDependency($this$configureBufDependency, BUF_BINARY_CONFIGURATION_NAME, MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)"build.buf"), TuplesKt.to((Object)"name", (Object)"buf"), TuplesKt.to((Object)"version", (Object)extension.getToolVersion()), TuplesKt.to((Object)"classifier", (Object)(osPart + '-' + archPart)), TuplesKt.to((Object)"ext", (Object)"exe")}));
    }

    public static final void execBuf(@NotNull Task $this$execBuf, @NotNull Object[] args, @Nullable Function1<? super String, String> customErrorMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$execBuf, (String)"$this$execBuf");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        BufSupportKt.execBuf($this$execBuf, ArraysKt.asList((Object[])args), customErrorMessage);
    }

    public static /* synthetic */ void execBuf$default(Task task, Object[] objectArray, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        BufSupportKt.execBuf(task, objectArray, (Function1<? super String, String>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void execBuf(@NotNull Task $this$execBuf, @NotNull Iterable<? extends Object> args, @Nullable Function1<? super String, String> customErrorMessage) {
        Object it2;
        File file;
        Project project;
        Intrinsics.checkNotNullParameter((Object)$this$execBuf, (String)"$this$execBuf");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Project $this$with = project = $this$execBuf.getProject();
        boolean bl = false;
        File executable = GradleSupportKt.singleFileFromConfiguration($this$with, BUF_BINARY_CONFIGURATION_NAME);
        if (!executable.canExecute()) {
            executable.setExecutable(true);
        }
        if (ProtobufGradlePluginSupportKt.hasProtobufGradlePlugin($this$with)) {
            file = OutputSupportKt.getBufbuildDir($this$with);
        } else {
            File file2 = $this$with.getProjectDir();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"projectDir");
        }
        File workingDir = file;
        List processArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)executable.getAbsolutePath()), args);
        $this$with.getLogger().info("Running buf from " + workingDir + ": `buf " + CollectionsKt.joinToString$default(args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + '`');
        Object object = new ProcessRunner();
        Object object2 = null;
        try {
            it2 = (ProcessRunner)object;
            boolean bl2 = false;
            it2 = ((ProcessRunner)it2).shell(workingDir, processArgs);
        }
        catch (Throwable it2) {
            object2 = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Object result = it2;
        if (((ProcessRunner.Result)result).getExitCode() != 0) {
            if (customErrorMessage != null) {
                object2 = ((ProcessRunner.Result)result).getStdOut();
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
                it2 = charset;
                String stdOut = new String((byte[])object2, (Charset)it2);
                it2 = ((ProcessRunner.Result)result).getStdErr();
                Charset charset2 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"StandardCharsets.UTF_8");
                Object object3 = charset2;
                String stdErr = new String((byte[])it2, (Charset)object3);
                IllegalStateException ex = new IllegalStateException((String)customErrorMessage.invoke((Object)stdOut));
                object3 = stdErr;
                if (object3.length() > 0) {
                    ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)new IllegalStateException(((ProcessRunner.Result)result).toString()));
                }
                throw (Throwable)ex;
            }
            object = ((ProcessRunner.Result)result).toString();
            throw new IllegalStateException(object.toString());
        }
    }

    public static /* synthetic */ void execBuf$default(Task task, Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        BufSupportKt.execBuf(task, iterable, (Function1<? super String, String>)function1);
    }
}

