/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.celext;

import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.List;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.ListT;
import org.projectnessie.cel.common.types.pb.Db;
import org.projectnessie.cel.common.types.pb.DefaultTypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;

final class Format {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final char[] LOWER_HEX_ARRAY = "0123456789abcdef".toCharArray();

    Format() {
    }

    static String format(String fmtString, ListT list) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int argIndex = 0;
        block6: while (index < fmtString.length()) {
            char c;
            if ((c = fmtString.charAt(index++)) != '%') {
                builder.append(c);
                if ((c & 0x80) == 0) continue;
                while (index < fmtString.length() && (fmtString.charAt(index) & 0xC0) == 128) {
                    builder.append(fmtString.charAt(index++));
                }
                continue;
            }
            if (index >= fmtString.length()) {
                throw new Err.ErrException("format: expected format specifier", new Object[0]);
            }
            if (fmtString.charAt(index) == '%') {
                builder.append('%');
                ++index;
                continue;
            }
            if ((long)argIndex >= list.size().intValue()) {
                throw new Err.ErrException("format: not enough arguments", new Object[0]);
            }
            Val arg = list.get((Val)IntT.intOf((long)argIndex++));
            c = fmtString.charAt(index++);
            int precision = 6;
            if (c == '.') {
                precision = 0;
                while (index < fmtString.length() && '0' <= fmtString.charAt(index) && fmtString.charAt(index) <= '9') {
                    precision = precision * 10 + (fmtString.charAt(index++) - 48);
                }
                if (index >= fmtString.length()) {
                    throw new Err.ErrException("format: expected format specifier", new Object[0]);
                }
                c = fmtString.charAt(index++);
            }
            switch (c) {
                case 'd': {
                    Format.formatDecimal(builder, arg);
                    continue block6;
                }
                case 'x': {
                    Format.formatHex(builder, arg, LOWER_HEX_ARRAY);
                    continue block6;
                }
                case 'X': {
                    Format.formatHex(builder, arg, HEX_ARRAY);
                    continue block6;
                }
                case 's': {
                    Format.formatString(builder, arg);
                    continue block6;
                }
            }
            throw new Err.ErrException("format: unparsable format specifier %s", new Object[]{Character.valueOf(c)});
        }
        return builder.toString();
    }

    private static String bytesToHex(byte[] bytes, char[] digits) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = digits[v >>> 4];
            hexChars[j * 2 + 1] = digits[v & 0xF];
        }
        return new String(hexChars);
    }

    private static void formatString(StringBuilder builder, Val val) {
        if (val.type().typeEnum() == TypeEnum.String) {
            builder.append(val.value());
        } else if (val.type().typeEnum() == TypeEnum.Bytes) {
            builder.append(val.value());
        } else {
            Format.formatStringSafe(builder, val, false);
        }
    }

    private static void formatStringSafe(StringBuilder builder, Val val, boolean listType) {
        TypeEnum type = val.type().typeEnum();
        if (type == TypeEnum.Bool) {
            builder.append(val.booleanValue());
        } else if (type == TypeEnum.Int || type == TypeEnum.Uint) {
            Format.formatDecimal(builder, val);
        } else if (type == TypeEnum.Double) {
            DecimalFormat format = new DecimalFormat("0.#");
            builder.append(format.format(val.value()));
        } else if (type == TypeEnum.String) {
            builder.append("\"").append(val.value().toString()).append("\"");
        } else if (type == TypeEnum.Bytes) {
            Format.formatBytes(builder, val);
        } else if (type == TypeEnum.Duration) {
            Format.formatDuration(builder, val, listType);
        } else if (type == TypeEnum.Timestamp) {
            Format.formatTimestamp(builder, val);
        } else if (type == TypeEnum.List) {
            Format.formatList(builder, val);
        } else {
            if (type == TypeEnum.Map) {
                throw new Err.ErrException("unimplemented stringSafe map type", new Object[0]);
            }
            if (type == TypeEnum.Null) {
                throw new Err.ErrException("unimplemented stringSafe null type", new Object[0]);
            }
        }
    }

    private static void formatList(StringBuilder builder, Val val) {
        builder.append('[');
        List list = (List)val.convertToNative(List.class);
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            Format.formatStringSafe(builder, DefaultTypeAdapter.nativeToValue((Db)Db.newDb(), null, obj), true);
            if (i == list.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(']');
    }

    private static void formatTimestamp(StringBuilder builder, Val val) {
        builder.append("timestamp(");
        Timestamp timestamp = (Timestamp)val.convertToNative(Timestamp.class);
        builder.append(timestamp.toString());
        builder.append(")");
    }

    private static void formatDuration(StringBuilder builder, Val val, boolean listType) {
        if (listType) {
            builder.append("duration(\"");
        }
        Duration duration = (Duration)val.convertToNative(Duration.class);
        double totalSeconds = (double)duration.getSeconds() + (double)duration.getNanos() / 1.0E9;
        DecimalFormat format = new DecimalFormat("0.#########");
        builder.append(format.format(totalSeconds));
        builder.append("s");
        if (listType) {
            builder.append("\")");
        }
    }

    private static void formatBytes(StringBuilder builder, Val val) {
        builder.append("\"").append(new String((byte[])val.value(), StandardCharsets.UTF_8)).append("\"");
    }

    private static void formatHex(StringBuilder builder, Val val, char[] digits) {
        String hexString;
        TypeEnum type = val.type().typeEnum();
        if (type == TypeEnum.Int || type == TypeEnum.Uint) {
            hexString = Long.toHexString(val.intValue());
        } else if (type == TypeEnum.Bytes) {
            byte[] bytes = (byte[])val.value();
            hexString = Format.bytesToHex(bytes, digits);
        } else if (type == TypeEnum.String) {
            hexString = val.value().toString();
        } else {
            throw new Err.ErrException("formatHex: expected int or string", new Object[0]);
        }
        builder.append(hexString);
    }

    private static void formatDecimal(StringBuilder builder, Val arg) {
        builder.append(arg.value());
    }
}

