package buzz.getcoco.media;

import java.util.concurrent.atomic.AtomicInteger;

class Context {

  private static final AtomicInteger ID_GEN = new AtomicInteger(0);

  private final int id;
  private final Object sdkContext;
  private final Object developerContext;

  public Context(Object developerContext, Object sdkContext) {
    this.sdkContext = sdkContext;
    this.developerContext = developerContext;

    this.id = ID_GEN.incrementAndGet();
  }

  @SuppressWarnings("unchecked")
  <T> T getSdkContext() {
    return (T) sdkContext;
  }

  @SuppressWarnings("unchecked")
  <T> T getDeveloperContext() {
    return (T) developerContext;
  }

  @Override
  public String toString() {
    return "Context{"
           + "id=" + id
           + ", sdkContext=" + sdkContext
           + ", developerContext=" + developerContext
           + '}';
  }
}
