package buzz.getcoco.media;

import java.nio.ByteBuffer;

class Native {

  static native int nativeInit(String cwdPath, String appAccessList,
                               String clientId, String downloadPath);

  static native int nativeSetTokens(String tokens);

  static native int nativeConnect(String networkId, Object context);

  static native int nativeDisconnect(String networkId);

  static native int nativeSendHttpCommand(String command, Object context);

  static native int nativeSendNetworkCommand(String command, Object context);

  static native int nativeJoinChannel(String networkId, int channelId, Object context);

  static native int nativeLeaveChannel(String networkId, int channelId);

  static native int nativeStartStream(String networkId, int channelId,
                                      long streamId, long sourceNodeId,
                                      String sdp, boolean isTx, Object context);

  static native int nativeSendFrameData(long streamHandle, ByteBuffer data);

  static native int nativeStopStream(long streamHandle, boolean isTx);

  static native int nativeSendMessage(String networkId, String message, boolean isMessage,
                                      int contentTime, long[] destinationNodes);
}
