package buzz.getcoco.media;

/**
 * The interface whose implementation decides on how commands are responded.
 *
 * @see DefaultNativeHandler
 * @see Native
 */
public interface NativeInterface {

  void init(String cwdPath, String appAccessList,
            String clientId, String downloadPath);

  void setTokens(String tokens);

  void connect(Network network);

  void disconnect(Network network);

  <V extends CommandResponse<CocoMediaClient.CommandId>,
      U extends Command<CocoMediaClient.CommandId, V>>
      void sendHttpCommand(U command, CocoMediaClient.CommandStatusListener<V> listener);

  <V extends CommandResponse<Network.CommandId>, U extends Command<Network.CommandId, V>>
      void sendNetworkCommand(Network network, U command,
                              Network.CommandStatusListener<V> listener);

  void joinChannel(Channel channel, Channel.ChannelStatusListener listener);

  void leaveChannel(Channel channel);

  void startStream(Stream stream, Stream.StreamStatusListener listener);

  void sendStreamData(Stream stream, Frame frame);

  void stopStream(Stream stream);

  void sendMessage(Network network, String message, long[] destinationNodes);

  void sendContentInfoMessage(Network network, String message,
                              int contentTime, long[] destinationNodes);
}
