package buzz.getcoco.media;

/**
 * A stream whose source is a node other than this.
 * Meant for receiving data only.
 */
public class RxStream extends Stream {

  private final RxStreamInfo streamInfo;

  /**
   * constructor for this class.
   *
   * @param streamInfo The stream info passed by
   *     {@link buzz.getcoco.media.Channel.ChannelStatusListener#onStreamInfoUpdated}
   */
  public RxStream(RxStreamInfo streamInfo) {

    super(streamInfo.getSdp(),
        streamInfo.getNetworkId(),
        streamInfo.getChannelId(),
        streamInfo.getStreamId());

    this.streamInfo = streamInfo;

    internalSetSourceNodeId(streamInfo.getSourceNodeId());
  }

  @Override
  protected boolean isTxStream() {
    return false;
  }

  /**
   * Start this stream.
   *
   * @param listener The listener which will get the data and status callbacks.
   * @throws Stream.StateException If this stream is starting, started or destroyed.
   */
  public void start(StreamStatusListener listener) throws Stream.StateException {
    if (RxStreamInfo.isDestroyed(streamInfo)) {
      throw new StateException(State.DESTROYED, "Stream is already destroyed");
    }

    super.internalStart(listener);
  }

  public void stop() {
    super.internalStop();
  }

  @Override
  protected void sendData(Frame frame) {
    throw new IllegalArgumentException("cannot send data into rx stream");
  }

  @Override
  public String toString() {
    return "RxStream{"
           + "streamInfo=" + streamInfo
           + "} "
           + super.toString();
  }
}
