package buzz.getcoco.media;

import java.util.logging.Logger;

/**
 * A stream whose source is this node and transfers data to other nodes.
 * Meant for sending data only.
 */
public class TxStream extends Stream {

  private static final Logger LOGGER = Util.getLogger();

  public TxStream(String sdp, Channel channel) {
    super(sdp, channel.getNetworkId(), channel.getId(), 0);
  }

  @Override
  protected boolean isTxStream() {
    return true;
  }

  public void create(StreamStatusListener listener) {
    LOGGER.fine("creating");
    super.internalStart(listener);
  }

  public void destroy() {
    LOGGER.fine("destroying");
    super.internalStop();
  }

  @Override
  public void sendData(Frame frame) {
    super.sendData(frame);
  }

  @Override
  public String toString() {
    return "TxStream{} " + super.toString();
  }
}
