/*
 * Decompiled with CFR 0.152.
 */
package by.stub.client;

import by.stub.annotations.CoberturaIgnore;
import by.stub.cli.CommandLineInterpreter;
import by.stub.client.Authorization;
import by.stub.client.StubbyRequest;
import by.stub.client.StubbyResponse;
import by.stub.http.StubbyHttpTransport;
import by.stub.server.StubbyManager;
import by.stub.server.StubbyManagerFactory;
import by.stub.utils.ObjectUtils;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;

public final class StubbyClient {
    private StubbyManager stubbyManager;

    @CoberturaIgnore
    public void startJetty(String yamlConfigurationFilename) throws Exception {
        this.startJetty(8882, 7443, 8889, "localhost", yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, String yamlConfigurationFilename) throws Exception {
        this.startJetty(stubsPort, 7443, 8889, "localhost", yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, int adminPort, String yamlConfigurationFilename) throws Exception {
        this.startJetty(stubsPort, 7443, adminPort, "localhost", yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, int tlsPort, int adminPort, String yamlConfigurationFilename) throws Exception {
        this.startJetty(stubsPort, tlsPort, adminPort, "localhost", yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, int adminPort, String addressToBind, String yamlConfigurationFilename) throws Exception {
        this.startJetty(stubsPort, 7443, adminPort, addressToBind, yamlConfigurationFilename);
    }

    @CoberturaIgnore
    public void startJetty(int stubsPort, int tlsPort, int adminPort, String addressToBind, String yamlConfigurationFilename) throws Exception {
        String[] args = new String[]{"-m", "-l", addressToBind, "-s", String.valueOf(stubsPort), "-a", String.valueOf(adminPort), "-t", String.valueOf(tlsPort)};
        CommandLineInterpreter commandLineInterpreter = new CommandLineInterpreter();
        commandLineInterpreter.parseCommandLine(args);
        this.stubbyManager = new StubbyManagerFactory().construct(yamlConfigurationFilename, commandLineInterpreter.getCommandlineParams());
        this.stubbyManager.startJetty();
    }

    @CoberturaIgnore
    public void startJettyYamless(int stubsPort, int tlsPort, int adminPort, String addressToBind) throws Exception {
        String[] args = new String[]{"-m", "-l", addressToBind, "-s", String.valueOf(stubsPort), "-a", String.valueOf(adminPort), "-t", String.valueOf(tlsPort)};
        CommandLineInterpreter commandLineInterpreter = new CommandLineInterpreter();
        commandLineInterpreter.parseCommandLine(args);
        URL url = StubbyClient.class.getResource("/yaml/empty-stub.yaml");
        this.stubbyManager = new StubbyManagerFactory().construct(url.getFile(), commandLineInterpreter.getCommandlineParams());
        this.stubbyManager.startJetty();
    }

    @CoberturaIgnore
    public void stopJetty() throws Exception {
        if (ObjectUtils.isNotNull(this.stubbyManager)) {
            this.stubbyManager.stopJetty();
        }
    }

    @CoberturaIgnore
    public void joinJetty() throws Exception {
        if (ObjectUtils.isNotNull(this.stubbyManager)) {
            this.stubbyManager.joinJetty();
        }
    }

    @CoberturaIgnore
    public StubbyResponse doGet(String host, String uri, int stubsPort) throws Exception {
        return this.doGet(host, uri, stubsPort, null);
    }

    @CoberturaIgnore
    public StubbyResponse doGetOverSsl(String host, String uri) throws Exception {
        return this.doGetOverSsl(host, uri, 7443, null);
    }

    @CoberturaIgnore
    public StubbyResponse doGetOverSsl(String host, String uri, int port) throws Exception {
        return this.doGetOverSsl(host, uri, port, null);
    }

    @CoberturaIgnore
    public StubbyResponse doGetOverSsl(String host, String uri, int port, Authorization authorization) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(HttpScheme.HTTPS.asString().toLowerCase(), HttpMethod.GET.asString(), uri, host, port, authorization);
        return this.makeRequest(stubbyRequest);
    }

    @CoberturaIgnore
    public StubbyResponse doGet(String host, String uri, int stubsPort, Authorization authorization) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(HttpScheme.HTTP.asString().toLowerCase(), HttpMethod.GET.asString(), uri, host, stubsPort, authorization);
        return this.makeRequest(stubbyRequest);
    }

    @CoberturaIgnore
    public StubbyResponse doGetUsingDefaults(String uri) throws Exception {
        return this.doGetUsingDefaults(uri, null);
    }

    @CoberturaIgnore
    public StubbyResponse doGetUsingDefaults(String uri, Authorization authorization) throws Exception {
        return this.doGet("localhost", uri, 8882, authorization);
    }

    @CoberturaIgnore
    public StubbyResponse doPost(String host, String uri, int stubsPort, String payload) throws Exception {
        return this.doPost(host, uri, stubsPort, null, payload);
    }

    @CoberturaIgnore
    public StubbyResponse doPost(String host, String uri, int stubsPort, Authorization authorization, String payload) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(HttpScheme.HTTP.asString().toLowerCase(), HttpMethod.POST.asString(), uri, host, stubsPort, authorization, payload);
        return this.makeRequest(stubbyRequest);
    }

    @CoberturaIgnore
    public StubbyResponse doPostUsingDefaults(String uri, String payload) throws Exception {
        return this.doPostUsingDefaults(uri, payload, null);
    }

    @CoberturaIgnore
    public StubbyResponse doPostUsingDefaults(String uri, String payload, Authorization authorization) throws Exception {
        return this.doPost("localhost", uri, 8882, authorization, payload);
    }

    @CoberturaIgnore
    public StubbyResponse doPut(String host, String uri, int stubsPort, Authorization authorization, String payload) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(HttpScheme.HTTP.asString().toLowerCase(), HttpMethod.PUT.asString(), uri, host, stubsPort, authorization, payload);
        return this.makeRequest(stubbyRequest);
    }

    @CoberturaIgnore
    public StubbyResponse doPutOverSsl(String host, String uri, int stubsPort, Authorization authorization, String payload) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(HttpScheme.HTTPS.asString().toLowerCase(), HttpMethod.PUT.asString(), uri, host, stubsPort, authorization, payload);
        return this.makeRequest(stubbyRequest);
    }

    @CoberturaIgnore
    public StubbyResponse doDelete(String host, String uri, int stubsPort, Authorization authorization) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(HttpScheme.HTTP.asString().toLowerCase(), HttpMethod.DELETE.asString(), uri, host, stubsPort, authorization);
        return this.makeRequest(stubbyRequest);
    }

    @CoberturaIgnore
    public StubbyResponse doDeleteOverSsl(String host, String uri, int port, Authorization authorization) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(HttpScheme.HTTPS.asString().toLowerCase(), HttpMethod.DELETE.asString(), uri, host, port, authorization);
        return this.makeRequest(stubbyRequest);
    }

    @CoberturaIgnore
    public StubbyResponse updateStubbedData(String url, String stubsData) throws Exception {
        URL adminUrl = new URL(url);
        return this.makeRequest(adminUrl.getProtocol(), HttpMethod.POST.asString(), adminUrl.getHost(), adminUrl.getPath(), adminUrl.getPort(), stubsData);
    }

    @CoberturaIgnore
    public StubbyResponse makeRequest(String scheme, String method, String host, String uri, int port, String post) throws Exception {
        return this.makeRequest(scheme, method, host, uri, port, post, null);
    }

    @CoberturaIgnore
    public StubbyResponse makeRequest(String scheme, String method, String host, String uri, int port, String post, Authorization authorization) throws Exception {
        StubbyRequest stubbyRequest = new StubbyRequest(scheme, method, uri, host, port, authorization, post);
        return this.makeRequest(stubbyRequest);
    }

    private StubbyResponse makeRequest(StubbyRequest stubbyRequest) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (ObjectUtils.isNotNull(stubbyRequest.getAuthorization())) {
            headers.put("Authorization", stubbyRequest.getAuthorization().asFullValue());
        }
        return new StubbyHttpTransport().getResponse(stubbyRequest.getMethod(), stubbyRequest.constructFullUrl(), stubbyRequest.getPost(), headers, stubbyRequest.calculatePostLength());
    }
}

