/*
 * Decompiled with CFR 0.152.
 */
package by.stub.client;

import by.stub.client.Authorization;
import by.stub.utils.StringUtils;

final class StubbyRequest {
    private static final String URL_TEMPLATE = "%s://%s:%s%s";
    private final String scheme;
    private final String method;
    private final String uri;
    private final String host;
    private final String post;
    private final Authorization authorization;
    private final int clientPort;

    StubbyRequest(String scheme, String method, String uri, String host, int port, Authorization authorization) {
        this(scheme, method, uri, host, port, authorization, null);
    }

    StubbyRequest(String scheme, String method, String uri, String host, int clientPort, Authorization authorization, String post) {
        this.scheme = scheme;
        this.method = method;
        this.uri = uri;
        this.host = host;
        this.clientPort = clientPort;
        this.post = post;
        this.authorization = authorization;
    }

    String getMethod() {
        return this.method;
    }

    String getPost() {
        return StringUtils.isSet(this.post) ? this.post : "";
    }

    Authorization getAuthorization() {
        return this.authorization;
    }

    String constructFullUrl() {
        return String.format(URL_TEMPLATE, this.scheme.toLowerCase(), this.host, this.clientPort, StringUtils.isSet(this.uri) ? this.uri : "");
    }

    int calculatePostLength() {
        return StringUtils.calculateStringLength(this.post);
    }
}

