/*
 * Decompiled with CFR 0.152.
 */
package by.stub.database;

import by.stub.cli.ANSITerminal;
import by.stub.client.StubbyResponse;
import by.stub.http.StubbyHttpTransport;
import by.stub.utils.FileUtils;
import by.stub.utils.ObjectUtils;
import by.stub.utils.ReflectionUtils;
import by.stub.yaml.YamlParser;
import by.stub.yaml.stubs.NotFoundStubResponse;
import by.stub.yaml.stubs.RedirectStubResponse;
import by.stub.yaml.stubs.StubHttpLifecycle;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import by.stub.yaml.stubs.UnauthorizedStubResponse;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class StubbedDataManager {
    private final File dataYaml;
    private final List<StubHttpLifecycle> stubHttpLifecycles;
    private StubbyHttpTransport stubbyHttpTransport;
    private final ConcurrentHashMap<String, AtomicLong> resourceStats;

    public StubbedDataManager(File dataYaml, List<StubHttpLifecycle> stubHttpLifecycles) {
        this.dataYaml = dataYaml;
        this.stubHttpLifecycles = Collections.synchronizedList(stubHttpLifecycles);
        this.stubbyHttpTransport = new StubbyHttpTransport();
        this.resourceStats = new ConcurrentHashMap();
    }

    public StubResponse findStubResponseFor(StubRequest assertingRequest) {
        StubHttpLifecycle assertingLifecycle = new StubHttpLifecycle();
        assertingLifecycle.setRequest(assertingRequest);
        assertingLifecycle.setResponse(StubResponse.newStubResponse());
        return this.identifyStubResponseType(assertingLifecycle);
    }

    private StubResponse identifyStubResponseType(StubHttpLifecycle assertingLifecycle) {
        StubHttpLifecycle matchedLifecycle = this.getMatchedStubHttpLifecycle(assertingLifecycle);
        if (ObjectUtils.isNull(matchedLifecycle)) {
            return new NotFoundStubResponse();
        }
        String resourceId = matchedLifecycle.getResourceId();
        this.resourceStats.putIfAbsent(resourceId, new AtomicLong(0L));
        this.resourceStats.get(resourceId).incrementAndGet();
        StubResponse stubResponse = matchedLifecycle.getResponse(true);
        if (matchedLifecycle.isAuthorizationRequired() && matchedLifecycle.isAssertingRequestUnauthorized(assertingLifecycle)) {
            return new UnauthorizedStubResponse();
        }
        if (stubResponse.hasHeaderLocation()) {
            return RedirectStubResponse.newRedirectStubResponse(stubResponse);
        }
        if (stubResponse.isRecordingRequired()) {
            String recordingSource = stubResponse.getBody();
            try {
                StubbyResponse stubbyResponse = this.stubbyHttpTransport.fetchRecordableHTTPResponse(matchedLifecycle.getRequest(), recordingSource);
                ReflectionUtils.injectObjectFields(stubResponse, "body", stubbyResponse.getContent());
            }
            catch (Exception e) {
                ANSITerminal.error(String.format("Could not record from %s: %s", recordingSource, e.toString()));
            }
        }
        return stubResponse;
    }

    private synchronized StubHttpLifecycle getMatchedStubHttpLifecycle(StubHttpLifecycle assertingLifecycle) {
        int listIndex = this.stubHttpLifecycles.indexOf(assertingLifecycle);
        if (listIndex < 0) {
            return StubHttpLifecycle.NULL;
        }
        StubHttpLifecycle foundStubHttpLifecycle = this.stubHttpLifecycles.get(listIndex);
        foundStubHttpLifecycle.setResourceId(listIndex);
        return foundStubHttpLifecycle;
    }

    public synchronized StubHttpLifecycle getMatchedStubHttpLifecycle(int index) {
        if (!this.isStubHttpLifecycleExistsByIndex(index)) {
            return StubHttpLifecycle.NULL;
        }
        return this.stubHttpLifecycles.get(index);
    }

    public synchronized boolean resetStubHttpLifecycles(List<StubHttpLifecycle> stubHttpLifecycles) {
        this.stubHttpLifecycles.clear();
        boolean added = this.stubHttpLifecycles.addAll(stubHttpLifecycles);
        if (added) {
            this.updateResourceIDHeaders();
        }
        return added;
    }

    public synchronized void refreshStubbedData(YamlParser yamlParser) throws Exception {
        List<StubHttpLifecycle> stubHttpLifecycles = yamlParser.parse(this.dataYaml.getParent(), this.dataYaml);
        this.resetStubHttpLifecycles(stubHttpLifecycles);
    }

    public synchronized void refreshStubbedData(YamlParser yamlParser, String post) throws Exception {
        List<StubHttpLifecycle> stubHttpLifecycles = yamlParser.parse(this.dataYaml.getParent(), post);
        this.resetStubHttpLifecycles(stubHttpLifecycles);
    }

    public synchronized String refreshStubbedData(YamlParser yamlParser, String put, int stubIndexToUpdate) throws Exception {
        List<StubHttpLifecycle> stubHttpLifecycles = yamlParser.parse(this.dataYaml.getParent(), put);
        StubHttpLifecycle newStubHttpLifecycle = stubHttpLifecycles.get(0);
        this.updateStubHttpLifecycleByIndex(stubIndexToUpdate, newStubHttpLifecycle);
        return newStubHttpLifecycle.getRequest().getUrl();
    }

    public List<StubHttpLifecycle> getStubHttpLifecycles() {
        return new LinkedList<StubHttpLifecycle>(this.stubHttpLifecycles);
    }

    public ConcurrentHashMap<String, AtomicLong> getResourceStats() {
        return new ConcurrentHashMap<String, AtomicLong>(this.resourceStats);
    }

    public String getResourceStatsAsCsv() {
        String csvNoHeader = this.resourceStats.toString().replaceAll("\\{|\\}", "").replaceAll(", ", FileUtils.BR).replaceAll("=", ",");
        return String.format("resourceId,hits%s%s", FileUtils.BR, csvNoHeader);
    }

    public synchronized String getOnlyStubRequestUrl() {
        return this.stubHttpLifecycles.get(0).getRequest().getUrl();
    }

    public File getDataYaml() {
        return this.dataYaml;
    }

    public synchronized Map<File, Long> getExternalFiles() {
        HashSet<String> escrow = new HashSet<String>();
        HashMap<File, Long> externalFiles = new HashMap<File, Long>();
        for (StubHttpLifecycle cycle : this.stubHttpLifecycles) {
            this.storeExternalFileInCache(escrow, externalFiles, cycle.getRequest().getRawFile());
            List<StubResponse> allResponses = cycle.getAllResponses();
            for (StubResponse stubbedResponse : allResponses) {
                this.storeExternalFileInCache(escrow, externalFiles, stubbedResponse.getRawFile());
            }
        }
        return externalFiles;
    }

    private void storeExternalFileInCache(Set<String> escrow, Map<File, Long> externalFiles, File file) {
        if (ObjectUtils.isNotNull(file) && !escrow.contains(file.getName())) {
            escrow.add(file.getName());
            externalFiles.put(file, file.lastModified());
        }
    }

    public String getYamlCanonicalPath() {
        try {
            return this.dataYaml.getCanonicalPath();
        }
        catch (IOException e) {
            return this.dataYaml.getAbsolutePath();
        }
    }

    public synchronized String getMarshalledYaml() {
        StringBuilder builder = new StringBuilder();
        for (StubHttpLifecycle cycle : this.stubHttpLifecycles) {
            builder.append(cycle.getHttpLifeCycleAsYaml()).append(FileUtils.BR + FileUtils.BR);
        }
        return builder.toString();
    }

    public synchronized String getMarshalledYamlByIndex(int httpLifecycleIndex) {
        return this.stubHttpLifecycles.get(httpLifecycleIndex).getHttpLifeCycleAsYaml();
    }

    public synchronized void updateStubHttpLifecycleByIndex(int httpLifecycleIndex, StubHttpLifecycle newStubHttpLifecycle) {
        this.deleteStubHttpLifecycleByIndex(httpLifecycleIndex);
        this.stubHttpLifecycles.add(httpLifecycleIndex, newStubHttpLifecycle);
        this.updateResourceIDHeaders();
    }

    public synchronized boolean isStubHttpLifecycleExistsByIndex(int httpLifecycleIndex) {
        return this.stubHttpLifecycles.size() - 1 >= httpLifecycleIndex;
    }

    public synchronized StubHttpLifecycle deleteStubHttpLifecycleByIndex(int httpLifecycleIndex) {
        StubHttpLifecycle removedLifecycle = this.stubHttpLifecycles.remove(httpLifecycleIndex);
        this.updateResourceIDHeaders();
        return removedLifecycle;
    }

    private void updateResourceIDHeaders() {
        for (int index = 0; index < this.stubHttpLifecycles.size(); ++index) {
            this.stubHttpLifecycles.get(index).setResourceId(index);
        }
    }
}

