/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers;

import by.stub.cli.ANSITerminal;
import by.stub.database.StubbedDataManager;
import by.stub.server.JettyContext;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.HandlerUtils;
import by.stub.yaml.YamlParser;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public final class StubDataRefreshActionHandler
extends AbstractHandler {
    private final StubbedDataManager stubbedDataManager;
    private final JettyContext jettyContext;

    public StubDataRefreshActionHandler(JettyContext newContext, StubbedDataManager newStubbedDataManager) {
        this.jettyContext = newContext;
        this.stubbedDataManager = newStubbedDataManager;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        if (response.isCommitted() || baseRequest.isHandled()) {
            ConsoleUtils.logIncomingRequestError(request, "stubData", "HTTP response was committed or base request was handled, aborting..");
            return;
        }
        baseRequest.setHandled(true);
        response.setContentType("text/plain;charset=UTF-8");
        response.setStatus(200);
        response.setHeader(HttpHeader.SERVER.asString(), HandlerUtils.constructHeaderServerName());
        try {
            this.stubbedDataManager.refreshStubbedData(new YamlParser());
            String successMessage = String.format("Successfully performed live refresh of main YAML from: %s on [" + new Date().toString().trim() + "]", this.stubbedDataManager.getDataYaml());
            response.getWriter().println(successMessage);
            ANSITerminal.ok(successMessage);
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
        ConsoleUtils.logOutgoingResponse(request.getRequestURI(), response);
    }
}

