/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy.admin;

import by.stub.handlers.strategy.admin.AdminResponseHandlingStrategy;
import by.stub.handlers.strategy.admin.DeleteHandlingStrategy;
import by.stub.handlers.strategy.admin.GetHandlingStrategy;
import by.stub.handlers.strategy.admin.HttpVerbsEnum;
import by.stub.handlers.strategy.admin.NullHandlingStrategy;
import by.stub.handlers.strategy.admin.PostHandlingStrategy;
import by.stub.handlers.strategy.admin.PutHandlingStrategy;
import javax.servlet.http.HttpServletRequest;

public final class AdminResponseHandlingStrategyFactory {
    private AdminResponseHandlingStrategyFactory() {
    }

    public static AdminResponseHandlingStrategy getStrategy(HttpServletRequest request) {
        HttpVerbsEnum verbEnum;
        String method = request.getMethod();
        try {
            verbEnum = HttpVerbsEnum.valueOf(method);
        }
        catch (IllegalArgumentException ex) {
            return new NullHandlingStrategy();
        }
        switch (verbEnum) {
            case POST: {
                return new PostHandlingStrategy();
            }
            case PUT: {
                return new PutHandlingStrategy();
            }
            case DELETE: {
                return new DeleteHandlingStrategy();
            }
        }
        return new GetHandlingStrategy();
    }
}

