/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy.admin;

import by.stub.database.StubbedDataManager;
import by.stub.handlers.strategy.admin.AdminResponseHandlingStrategy;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetHandlingStrategy
implements AdminResponseHandlingStrategy {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, StubbedDataManager stubbedDataManager) throws IOException {
        StringBuilder yamlAppender = new StringBuilder();
        int contextPathLength = "/".length();
        String pathInfoNoHeadingSlash = request.getRequestURI().substring(contextPathLength);
        if (StringUtils.isSet(pathInfoNoHeadingSlash)) {
            int targetHttpStubCycleIndex = Integer.parseInt(pathInfoNoHeadingSlash);
            if (!stubbedDataManager.isStubHttpLifecycleExistsByIndex(targetHttpStubCycleIndex)) {
                String errorMessage = String.format("Stub request index#%s does not exist, cannot display", targetHttpStubCycleIndex);
                HandlerUtils.configureErrorResponse(response, 204, errorMessage);
                return;
            }
            yamlAppender.append(stubbedDataManager.getMarshalledYamlByIndex(targetHttpStubCycleIndex));
        } else {
            yamlAppender.append(stubbedDataManager.getMarshalledYaml());
        }
        response.setContentType("text/plain;charset=UTF-8");
        ServletOutputStream streamOut = response.getOutputStream();
        streamOut.write(StringUtils.getBytesUtf8(yamlAppender.toString()));
        streamOut.flush();
        streamOut.close();
    }
}

