/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy.admin;

import by.stub.database.StubbedDataManager;
import by.stub.handlers.strategy.admin.AdminResponseHandlingStrategy;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.YamlParser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;

public class PostHandlingStrategy
implements AdminResponseHandlingStrategy {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, StubbedDataManager stubbedDataManager) throws Exception {
        if (!request.getRequestURI().equals("/")) {
            response.setStatus(405);
            response.getWriter().println("Method POST is not allowed on URI " + request.getRequestURI());
            return;
        }
        String post = HandlerUtils.extractPostRequestBody(request, "admin");
        if (!StringUtils.isSet(post)) {
            String errorMessage = String.format("%s request on URI %s was empty", request.getMethod(), request.getRequestURI());
            HandlerUtils.configureErrorResponse(response, 204, errorMessage);
            return;
        }
        stubbedDataManager.refreshStubbedData(new YamlParser(), post);
        if (stubbedDataManager.getStubHttpLifecycles().size() == 1) {
            response.addHeader(HttpHeader.LOCATION.asString(), stubbedDataManager.getOnlyStubRequestUrl());
        }
        response.setStatus(201);
        response.getWriter().println("Configuration created successfully");
    }
}

