/*
 * Decompiled with CFR 0.152.
 */
package by.stub.handlers.strategy.stubs;

import by.stub.annotations.VisibleForTesting;
import by.stub.handlers.strategy.stubs.StubResponseHandlingStrategy;
import by.stub.utils.HandlerUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubRequest;
import javax.servlet.http.HttpServletResponse;

public final class UnauthorizedResponseHandlingStrategy
implements StubResponseHandlingStrategy {
    @VisibleForTesting
    public static final String NO_AUTHORIZATION_HEADER = "You are not authorized to view this page without supplied 'Authorization' HTTP header";
    @VisibleForTesting
    public static final String WRONG_AUTHORIZATION_HEADER_TEMPLATE = "Unauthorized with supplied 'authorized' header value: '%s'";

    @Override
    public void handle(HttpServletResponse response, StubRequest assertionStubRequest) throws Exception {
        HandlerUtils.setResponseMainHeaders(response);
        String authorizationHeader = assertionStubRequest.getRawAuthorizationHttpHeader();
        if (!StringUtils.isSet(authorizationHeader)) {
            HandlerUtils.configureErrorResponse(response, 401, NO_AUTHORIZATION_HEADER);
            return;
        }
        HandlerUtils.configureErrorResponse(response, 401, String.format(WRONG_AUTHORIZATION_HEADER_TEMPLATE, authorizationHeader));
    }
}

