/*
 * Decompiled with CFR 0.152.
 */
package by.stub.http;

import by.stub.cli.ANSITerminal;
import by.stub.client.StubbyResponse;
import by.stub.common.Common;
import by.stub.exception.Stubby4JException;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;

public class StubbyHttpTransport {
    private static final Set<String> SUPPORTED_METHODS = new HashSet<String>(){
        {
            this.add(HttpMethod.GET.asString());
            this.add(HttpMethod.HEAD.asString());
            this.add(HttpMethod.TRACE.asString());
            this.add(HttpMethod.OPTIONS.asString());
            this.add(HttpMethod.DELETE.asString());
            this.add(HttpMethod.POST.asString());
            this.add(HttpMethod.PUT.asString());
        }
    };

    public StubbyResponse fetchRecordableHTTPResponse(StubRequest request, String destinationToRecordUrl) throws IOException {
        String method = request.getMethod().get(0);
        String fullUrl = String.format("%s%s", destinationToRecordUrl, request.getUrl());
        if (!ANSITerminal.isMute()) {
            String logMessage = String.format("[%s] -> Recording HTTP response using %s [%s]", ConsoleUtils.getTime(), method, fullUrl);
            ANSITerminal.incoming(logMessage);
        }
        return this.getResponse(method, fullUrl, request.getPostBody(), request.getHeaders(), StringUtils.calculateStringLength(request.getPostBody()));
    }

    public StubbyResponse getResponse(String method, String fullUrl, String post, Map<String, String> headers, int postLength) throws IOException {
        if (!SUPPORTED_METHODS.contains(method)) {
            throw new Stubby4JException(String.format("HTTP method '%s' not supported when contacting stubby4j", method));
        }
        URL url = new URL(fullUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        this.setRequestHeaders(connection, headers, postLength);
        if (Common.POSTING_METHODS.contains(method)) {
            this.writePost(connection, post);
        }
        return this.buildStubbyResponse(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StubbyResponse buildStubbyResponse(HttpURLConnection connection) throws IOException {
        try {
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200 || responseCode == 201) {
                InputStream inputStream = connection.getInputStream();
                String responseContent = StringUtils.inputStreamToString(inputStream);
                inputStream.close();
                StubbyResponse stubbyResponse = new StubbyResponse(responseCode, responseContent);
                return stubbyResponse;
            }
            StubbyResponse stubbyResponse = new StubbyResponse(responseCode, connection.getResponseMessage());
            return stubbyResponse;
        }
        finally {
            connection.disconnect();
        }
    }

    private void setRequestHeaders(HttpURLConnection connection, Map<String, String> headers, int postLength) {
        connection.setRequestProperty("User-Agent", StringUtils.constructUserAgentName());
        String requestMethod = connection.getRequestMethod();
        if (Common.POSTING_METHODS.contains(StringUtils.toUpper(requestMethod))) {
            connection.setDoOutput(true);
            connection.setRequestProperty(HttpHeader.CONTENT_TYPE.asString(), "application/x-www-form-urlencoded");
            connection.setRequestProperty(HttpHeader.CONTENT_LANGUAGE.asString(), "en-US");
            connection.setRequestProperty(HttpHeader.CONTENT_ENCODING.asString(), "UTF-8");
            connection.setRequestProperty(HttpHeader.CONTENT_LENGTH.asString(), Integer.toString(postLength));
            if (postLength > 0) {
                connection.setFixedLengthStreamingMode(postLength);
            } else {
                connection.setChunkedStreamingMode(0);
            }
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePost(HttpURLConnection connection, String post) throws IOException {
        try (OutputStreamWriter streamWriter = new OutputStreamWriter(connection.getOutputStream(), StringUtils.charsetUTF8());){
            streamWriter.write(post);
            streamWriter.flush();
        }
    }
}

