/*
 * Decompiled with CFR 0.152.
 */
package by.stub.server;

import by.stub.cli.ANSITerminal;
import by.stub.database.StubbedDataManager;
import by.stub.exception.Stubby4JException;
import by.stub.handlers.AdminPortalHandler;
import by.stub.handlers.AjaxEndpointStatsHandler;
import by.stub.handlers.AjaxResourceContentHandler;
import by.stub.handlers.FaviconHandler;
import by.stub.handlers.StatusPageHandler;
import by.stub.handlers.StubDataRefreshActionHandler;
import by.stub.handlers.StubsPortalHandler;
import by.stub.server.FakeX509TrustManager;
import by.stub.server.JettyContext;
import by.stub.utils.ObjectUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlets.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class JettyFactory {
    public static final int DEFAULT_ADMIN_PORT = 8889;
    public static final int DEFAULT_STUBS_PORT = 8882;
    public static final int DEFAULT_SSL_PORT = 7443;
    private static final int SERVER_CONNECTOR_IDLETIME_MILLIS = 45000;
    private static final String PROTOCOL_HTTP_1_1 = "HTTP/1.1";
    public static final String DEFAULT_HOST = "localhost";
    static final String ADMIN_CONNECTOR_NAME = "AdminConnector";
    static final String STUBS_CONNECTOR_NAME = "StubsConnector";
    static final String SSL_CONNECTOR_NAME = "SslStubsConnector";
    private static final String ROOT_PATH_INFO = "/";
    private final Map<String, String> commandLineArgs;
    private final StubbedDataManager stubbedDataManager;
    private String currentHost;
    private int currentStubsPort;
    private int currentAdminPort;
    private int currentStubsSslPort;

    public JettyFactory(Map<String, String> commandLineArgs, StubbedDataManager stubbedDataManager) {
        this.commandLineArgs = commandLineArgs;
        this.stubbedDataManager = stubbedDataManager;
    }

    public Server construct() throws IOException {
        Server server = new Server();
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        server.setConnectors(this.buildConnectors(server));
        server.setHandler(this.constructHandlers());
        return server;
    }

    private ContextHandlerCollection constructHandlers() {
        JettyContext jettyContext = new JettyContext(this.currentHost, this.currentStubsPort, this.currentStubsSslPort, this.currentAdminPort);
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        handlers.setHandlers(new Handler[]{this.constructHandler(STUBS_CONNECTOR_NAME, "/favicon.ico", this.gzipHandler(new FaviconHandler())), this.constructHandler(STUBS_CONNECTOR_NAME, ROOT_PATH_INFO, this.gzipHandler(new StubsPortalHandler(this.stubbedDataManager))), this.constructHandler(SSL_CONNECTOR_NAME, "/favicon.ico", this.gzipHandler(new FaviconHandler())), this.constructHandler(SSL_CONNECTOR_NAME, ROOT_PATH_INFO, this.gzipHandler(new StubsPortalHandler(this.stubbedDataManager))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/status", this.gzipHandler(new StatusPageHandler(jettyContext, this.stubbedDataManager))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/refresh", new StubDataRefreshActionHandler(jettyContext, this.stubbedDataManager)), this.constructHandler(ADMIN_CONNECTOR_NAME, "/js/highlight", this.gzipHandler(this.staticResourceHandler("ui/js/highlight/"))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/js/minified", this.gzipHandler(this.staticResourceHandler("ui/js/minified/"))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/js/d3", this.gzipHandler(this.staticResourceHandler("ui/js/d3/"))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/js", this.gzipHandler(this.staticResourceHandler("ui/js/"))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/css", this.gzipHandler(this.staticResourceHandler("ui/css/"))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/images", this.gzipHandler(this.staticResourceHandler("ui/images/"))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/ajax/resource", this.gzipHandler(new AjaxResourceContentHandler(this.stubbedDataManager))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/ajax/stats", this.gzipHandler(new AjaxEndpointStatsHandler(this.stubbedDataManager))), this.constructHandler(ADMIN_CONNECTOR_NAME, "/favicon.ico", this.gzipHandler(new FaviconHandler())), this.constructHandler(ADMIN_CONNECTOR_NAME, ROOT_PATH_INFO, this.gzipHandler(new AdminPortalHandler(this.stubbedDataManager)))});
        return handlers;
    }

    private ResourceHandler staticResourceHandler(String classPathResource) {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setBaseResource(Resource.newClassPathResource(classPathResource));
        return resourceHandler;
    }

    private GzipHandler gzipHandler(AbstractHandler abstractHandler) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMimeTypes("text/html,text/plain,text/xml,application/xhtml+xml,application/json,text/css,application/javascript,application/x-javascript,image/svg+xml,image/x-icon,image/gif,image/jpg,image/jpeg,image/png");
        gzipHandler.setHandler(abstractHandler);
        return gzipHandler;
    }

    private ContextHandler constructHandler(String connectorName, String pathInfo, Handler handler) {
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath(pathInfo);
        contextHandler.setAllowNullPathInfo(true);
        contextHandler.setVirtualHosts(new String[]{"@" + connectorName});
        contextHandler.addLocaleEncoding(Locale.US.getDisplayName(), "UTF-8");
        contextHandler.setHandler(handler);
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.setMimeMap(new HashMap<String, String>());
        contextHandler.setMimeTypes(mimeTypes);
        return contextHandler;
    }

    private Connector[] buildConnectors(Server server) throws IOException {
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        if (!this.commandLineArgs.containsKey("disable_admin_portal")) {
            connectors.add(this.buildAdminConnector(server));
        }
        connectors.add(this.buildStubsConnector(server));
        if (!this.commandLineArgs.containsKey("disable_ssl")) {
            connectors.add(this.buildStubsSslConnector(server));
        }
        return connectors.toArray(new Connector[connectors.size()]);
    }

    private ServerConnector buildAdminConnector(Server server) {
        HttpConfiguration httpConfiguration = this.constructHttpConfiguration();
        ServerConnector adminChannel = new ServerConnector(server, new HttpConnectionFactory(httpConfiguration));
        adminChannel.setPort(this.getAdminPort(this.commandLineArgs));
        adminChannel.setName(ADMIN_CONNECTOR_NAME);
        adminChannel.setHost(DEFAULT_HOST);
        adminChannel.setIdleTimeout(45000L);
        if (this.commandLineArgs.containsKey("location")) {
            adminChannel.setHost(this.commandLineArgs.get("location"));
        }
        String configured = String.format("Admin portal configured at http://%s:%s", adminChannel.getHost(), adminChannel.getPort());
        ANSITerminal.status(configured);
        String status = String.format("Admin portal status enabled at http://%s:%s/status", adminChannel.getHost(), adminChannel.getPort());
        ANSITerminal.status(status);
        this.currentHost = adminChannel.getHost();
        this.currentAdminPort = adminChannel.getPort();
        return adminChannel;
    }

    private ServerConnector buildStubsConnector(Server server) {
        HttpConfiguration httpConfiguration = this.constructHttpConfiguration();
        ServerConnector stubsChannel = new ServerConnector(server, new HttpConnectionFactory(httpConfiguration));
        stubsChannel.setPort(this.getStubsPort(this.commandLineArgs));
        stubsChannel.setName(STUBS_CONNECTOR_NAME);
        stubsChannel.setHost(DEFAULT_HOST);
        stubsChannel.setIdleTimeout(45000L);
        if (this.commandLineArgs.containsKey("location")) {
            stubsChannel.setHost(this.commandLineArgs.get("location"));
        }
        String status = String.format("Stubs portal configured at http://%s:%s", stubsChannel.getHost(), stubsChannel.getPort());
        ANSITerminal.status(status);
        this.currentStubsPort = stubsChannel.getPort();
        return stubsChannel;
    }

    private ServerConnector buildStubsSslConnector(Server server) throws IOException {
        String keystorePath = null;
        String password = "password";
        if (this.commandLineArgs.containsKey("keystore") && this.commandLineArgs.containsKey("password")) {
            password = this.commandLineArgs.get("password");
            keystorePath = this.commandLineArgs.get("keystore");
        }
        HttpConfiguration httpConfiguration = this.constructHttpConfiguration();
        httpConfiguration.setSecureScheme(HttpScheme.HTTPS.asString());
        httpConfiguration.setSecurePort(this.getStubsSslPort(this.commandLineArgs));
        httpConfiguration.addCustomizer(new SecureRequestCustomizer());
        SslContextFactory sslContextFactory = this.constructSslContextFactory(password, keystorePath);
        ServerConnector sslConnector = new ServerConnector(server, new SslConnectionFactory(sslContextFactory, PROTOCOL_HTTP_1_1), new HttpConnectionFactory(httpConfiguration));
        sslConnector.setPort(this.getStubsSslPort(this.commandLineArgs));
        sslConnector.setHost(DEFAULT_HOST);
        sslConnector.setName(SSL_CONNECTOR_NAME);
        sslConnector.setIdleTimeout(45000L);
        if (this.commandLineArgs.containsKey("location")) {
            sslConnector.setHost(this.commandLineArgs.get("location"));
        }
        String status = String.format("Stubs portal configured with TLS at https://%s:%s using %s keystore", sslConnector.getHost(), sslConnector.getPort(), ObjectUtils.isNull(keystorePath) ? "internal" : "provided " + keystorePath);
        ANSITerminal.status(status);
        this.currentStubsSslPort = sslConnector.getPort();
        return sslConnector;
    }

    private SslContextFactory constructSslContextFactory(String password, String keystorePath) throws IOException {
        SslContextFactory sslFactory = new SslContextFactory();
        sslFactory.setKeyStorePassword(password);
        sslFactory.setKeyManagerPassword(password);
        this.relaxSslTrustManager();
        if (ObjectUtils.isNull(keystorePath)) {
            URL keyURL = this.getClass().getResource("/ssl/localhost.jks");
            Resource keyStoreResource = Resource.newResource(keyURL);
            sslFactory.setKeyStoreResource(keyStoreResource);
            return sslFactory;
        }
        sslFactory.setKeyStorePath(keystorePath);
        return sslFactory;
    }

    private void relaxSslTrustManager() {
        try {
            new FakeX509TrustManager().allowAllSSL();
        }
        catch (Exception ex) {
            throw new Stubby4JException(ex.toString(), ex);
        }
    }

    private HttpConfiguration constructHttpConfiguration() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setSendServerVersion(true);
        httpConfiguration.setSendXPoweredBy(true);
        httpConfiguration.setOutputBufferSize(32768);
        httpConfiguration.setRequestHeaderSize(8192);
        httpConfiguration.setResponseHeaderSize(8192);
        return httpConfiguration;
    }

    private int getStubsPort(Map<String, String> commandLineArgs) {
        if (commandLineArgs.containsKey("stubs")) {
            return Integer.parseInt(commandLineArgs.get("stubs"));
        }
        return 8882;
    }

    private int getStubsSslPort(Map<String, String> commandLineArgs) {
        if (commandLineArgs.containsKey("tls")) {
            return Integer.parseInt(commandLineArgs.get("tls"));
        }
        return 7443;
    }

    private int getAdminPort(Map<String, String> commandLineArgs) {
        if (commandLineArgs.containsKey("admin")) {
            return Integer.parseInt(commandLineArgs.get("admin"));
        }
        return 8889;
    }
}

