/*
 * Decompiled with CFR 0.152.
 */
package by.stub.server;

import by.stub.cli.ANSITerminal;
import by.stub.utils.FileUtils;
import org.eclipse.jetty.server.Server;

public final class StubbyManager {
    private final Server server;

    public StubbyManager(Server server) {
        this.server = server;
    }

    public synchronized void startJetty() throws Exception {
        if (this.isJettyStarting() || this.isJettyUp()) {
            return;
        }
        this.server.start();
        while (!this.isJettyUp()) {
            ANSITerminal.warn("Waiting for Jetty to finish starting up..");
            Thread.sleep(250L);
        }
        ANSITerminal.status("Jetty successfully started");
        ANSITerminal.info(FileUtils.BR + "Quit: ctrl-c" + FileUtils.BR);
    }

    public synchronized void stopJetty() throws Exception {
        if (this.isJettyStopping() || this.isJettyDown()) {
            return;
        }
        this.server.stop();
        while (!this.isJettyDown()) {
            ANSITerminal.warn("Waiting for Jetty to finish shutting down..");
            Thread.sleep(250L);
        }
        ANSITerminal.status("Jetty successfully shutdown");
    }

    public synchronized void joinJetty() throws Exception {
        this.server.join();
    }

    private boolean isJettyStarting() throws Exception {
        return this.server.isStarting();
    }

    private boolean isJettyUp() throws Exception {
        return this.server.isStarted() && this.server.isRunning();
    }

    private boolean isJettyStopping() throws Exception {
        return this.server.isStopping();
    }

    private boolean isJettyDown() throws Exception {
        return this.server.isStopped() && !this.server.isRunning();
    }
}

