/*
 * Decompiled with CFR 0.152.
 */
package by.stub.server;

import by.stub.cli.EmptyLogger;
import by.stub.database.StubbedDataManager;
import by.stub.database.thread.ExternalFilesScanner;
import by.stub.database.thread.MainYamlScanner;
import by.stub.server.JettyFactory;
import by.stub.server.StubbyManager;
import by.stub.utils.FileUtils;
import by.stub.utils.ObjectUtils;
import by.stub.yaml.YamlParser;
import by.stub.yaml.stubs.StubHttpLifecycle;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;

public class StubbyManagerFactory {
    public synchronized StubbyManager construct(String dataYamlFilename, Map<String, String> commandLineArgs) throws Exception {
        Log.setLog(new EmptyLogger());
        File dataYamlFile = new File(dataYamlFilename);
        List<StubHttpLifecycle> httpLifecycles = new YamlParser().parse(dataYamlFile.getParent(), FileUtils.constructReader(dataYamlFile));
        System.out.println();
        StubbedDataManager stubbedDataManager = new StubbedDataManager(dataYamlFile, httpLifecycles);
        JettyFactory jettyFactory = new JettyFactory(commandLineArgs, stubbedDataManager);
        Server server = jettyFactory.construct();
        if (commandLineArgs.containsKey("watch")) {
            String watchValue = commandLineArgs.get("watch");
            long watchScanTime = ObjectUtils.isNotNull(watchValue) ? Long.parseLong(watchValue) : 100L;
            this.watchDataStore(stubbedDataManager, watchScanTime);
        }
        return new StubbyManager(server);
    }

    private void watchDataStore(StubbedDataManager stubbedDataManager, long sleepTime) {
        MainYamlScanner mainYamlScanner = new MainYamlScanner(stubbedDataManager, sleepTime);
        new Thread((Runnable)mainYamlScanner, MainYamlScanner.class.getCanonicalName()).start();
        ExternalFilesScanner externalFilesScanner = new ExternalFilesScanner(stubbedDataManager, sleepTime);
        new Thread((Runnable)externalFilesScanner, ExternalFilesScanner.class.getCanonicalName()).start();
    }
}

