/*
 * Decompiled with CFR 0.152.
 */
package by.stub.utils;

import by.stub.utils.StringUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map<String, String> constructParamMap(String queryString) {
        String[] pairs;
        if (!StringUtils.isSet(queryString)) {
            return new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        for (String pair : pairs = queryString.split("&")) {
            String splittedPairValue;
            String[] splittedPair = pair.split("=");
            String splittedPairKey = splittedPair[0];
            String string = splittedPairValue = splittedPair.length > 1 ? splittedPair[1] : "";
            if (StringUtils.isWithinSquareBrackets(splittedPairValue)) {
                String cleansedValue = StringUtils.decodeUrlEncodedQuotes(StringUtils.removeSquareBrackets(splittedPairValue));
                String bracketedQueryValueAsCSV = Arrays.asList(cleansedValue.split(",")).toString();
                splittedPairValue = StringUtils.trimSpacesBetweenCSVElements(bracketedQueryValueAsCSV);
            }
            paramMap.put(splittedPairKey, splittedPairValue);
        }
        return paramMap;
    }

    public static String constructQueryString(Map<String, String> query) {
        Set<Map.Entry<String, String>> mapEntries = query.entrySet();
        Iterator<Map.Entry<String, String>> iterator = mapEntries.iterator();
        StringBuilder queryStringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String pair = String.format("%s=%s", entry.getKey(), entry.getValue());
            queryStringBuilder.append(pair);
            if (!iterator.hasNext()) continue;
            queryStringBuilder.append('&');
        }
        return queryStringBuilder.toString();
    }
}

