/*
 * Decompiled with CFR 0.152.
 */
package by.stub.yaml;

import by.stub.annotations.CoberturaIgnore;
import by.stub.cli.ANSITerminal;
import by.stub.utils.ConsoleUtils;
import by.stub.utils.FileUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.StubBuilder;
import by.stub.yaml.StubRequestBuilder;
import by.stub.yaml.StubResponseBuilder;
import by.stub.yaml.stubs.StubAuthorizationTypes;
import by.stub.yaml.stubs.StubHttpLifecycle;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import parser.yaml.SnakeYaml;

public class YamlParser {
    public static final String FAILED_TO_LOAD_FILE_ERR = "Failed to load response content using relative path specified in 'file'. Check that response content exists in relative path specified in 'file'";
    private String dataConfigHomeDirectory;
    private static final Yaml SNAKE_YAML = SnakeYaml.INSTANCE.getSnakeYaml();

    public List<StubHttpLifecycle> parse(String dataConfigHomeDirectory, String yaml) throws Exception {
        return this.parse(dataConfigHomeDirectory, FileUtils.constructReader(yaml));
    }

    @CoberturaIgnore
    public List<StubHttpLifecycle> parse(String dataConfigHomeDirectory, File yamlFile) throws Exception {
        return this.parse(dataConfigHomeDirectory, FileUtils.constructReader(yamlFile));
    }

    public List<StubHttpLifecycle> parse(String dataConfigHomeDirectory, Reader yamlReader) throws Exception {
        Object loadedYaml = SNAKE_YAML.load(yamlReader);
        if (!(loadedYaml instanceof List)) {
            throw new IOException("Loaded YAML root node must be an instance of ArrayList, otherwise something went wrong. Check provided YAML");
        }
        this.dataConfigHomeDirectory = dataConfigHomeDirectory;
        List loadedYamlData = (List)loadedYaml;
        LinkedList<StubHttpLifecycle> httpLifecycles = new LinkedList<StubHttpLifecycle>();
        for (Object rawParentNode : loadedYamlData) {
            Map parentNodePropertiesMap = (Map)rawParentNode;
            StubHttpLifecycle stubHttpLifecycle = this.unmarshallYamlNodeToHttpLifeCycle(parentNodePropertiesMap);
            httpLifecycles.add(stubHttpLifecycle);
            stubHttpLifecycle.setResourceId(httpLifecycles.size() - 1);
        }
        return httpLifecycles;
    }

    private StubHttpLifecycle unmarshallYamlNodeToHttpLifeCycle(Map<String, Object> parentNodesMap) throws Exception {
        StubHttpLifecycle httpLifecycle = new StubHttpLifecycle();
        for (Map.Entry<String, Object> parentNode : parentNodesMap.entrySet()) {
            Object parentNodeValue = parentNode.getValue();
            if (parentNodeValue instanceof Map) {
                this.handleMapNode(httpLifecycle, parentNode);
                continue;
            }
            if (!(parentNodeValue instanceof List)) continue;
            this.handleListNode(httpLifecycle, parentNode);
        }
        httpLifecycle.setHttpLifeCycleAsYaml(this.marshallNodeMapToYaml(parentNodesMap));
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("request", parentNodesMap.get("request"));
        httpLifecycle.setRequestAsYaml(this.marshallNodeToYaml(requestMap));
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("response", parentNodesMap.get("response"));
        httpLifecycle.setResponseAsYaml(this.marshallNodeToYaml(responseMap));
        return httpLifecycle;
    }

    private void handleMapNode(StubHttpLifecycle stubHttpLifecycle, Map.Entry<String, Object> parentNode) throws Exception {
        Map yamlProperties = (Map)parentNode.getValue();
        if (parentNode.getKey().equals("request")) {
            StubRequest targetStub = (StubRequest)this.unmarshallYamlMapToTargetStub(yamlProperties, new StubRequestBuilder());
            stubHttpLifecycle.setRequest(targetStub);
            ConsoleUtils.logUnmarshalledStubRequest(targetStub.getMethod(), targetStub.getUrl());
        } else {
            StubResponse targetStub = (StubResponse)this.unmarshallYamlMapToTargetStub(yamlProperties, new StubResponseBuilder());
            stubHttpLifecycle.setResponse(targetStub);
        }
    }

    private <T, B extends StubBuilder<T>> T unmarshallYamlMapToTargetStub(Map<String, Object> yamlProperties, B stubBuilder) throws Exception {
        for (Map.Entry<String, Object> pair : yamlProperties.entrySet()) {
            Object massagedFieldValue;
            Map<String, String> rawFieldName = pair.getValue();
            String fieldName = pair.getKey();
            if (rawFieldName instanceof List) {
                massagedFieldValue = rawFieldName;
            } else if (rawFieldName instanceof Map) {
                massagedFieldValue = this.configureAuthorizationHeader(rawFieldName);
            } else if (fieldName.toLowerCase().equals("method")) {
                ArrayList<String> methods = new ArrayList<String>(1);
                methods.add(StringUtils.objectToString(rawFieldName));
                massagedFieldValue = methods;
            } else {
                massagedFieldValue = this.isPairKeyEqualsToYamlNodeFile(fieldName) ? this.loadFileContentFromFileUrl(rawFieldName) : StringUtils.objectToString(rawFieldName);
            }
            stubBuilder.store(fieldName, massagedFieldValue);
        }
        return stubBuilder.build();
    }

    private void handleListNode(StubHttpLifecycle stubHttpLifecycle, Map.Entry<String, Object> parentNode) throws Exception {
        List yamlProperties = (List)parentNode.getValue();
        List populatedResponseStub = this.unmarshallYamlListToTargetStub(yamlProperties, new StubResponseBuilder());
        stubHttpLifecycle.setResponse(populatedResponseStub);
    }

    private <T, B extends StubBuilder<T>> List<T> unmarshallYamlListToTargetStub(List yamlProperties, B stubBuilder) throws Exception {
        LinkedList<T> targetStubList = new LinkedList<T>();
        for (Object arrayListEntry : yamlProperties) {
            Map rawSequenceEntry = (Map)arrayListEntry;
            for (Map.Entry mapEntry : rawSequenceEntry.entrySet()) {
                String rawFieldName = (String)mapEntry.getKey();
                Object rawFieldValue = mapEntry.getValue();
                if (this.isPairKeyEqualsToYamlNodeFile(rawFieldName)) {
                    rawFieldValue = this.loadFileContentFromFileUrl(rawFieldValue);
                }
                stubBuilder.store(rawFieldName, rawFieldValue);
            }
            targetStubList.add(stubBuilder.build());
        }
        return targetStubList;
    }

    private boolean isPairKeyEqualsToYamlNodeFile(String pairKey) {
        return pairKey.toLowerCase().equals("file");
    }

    private Object loadFileContentFromFileUrl(Object rawPairValue) throws IOException {
        String filePath = StringUtils.objectToString(rawPairValue);
        try {
            if (FileUtils.doesFilePathContainTemplateTokens(new File(filePath))) {
                return new File(this.dataConfigHomeDirectory, filePath);
            }
            return FileUtils.uriToFile(this.dataConfigHomeDirectory, filePath);
        }
        catch (IOException ex) {
            ANSITerminal.error(ex.getMessage() + " " + FAILED_TO_LOAD_FILE_ERR);
            return null;
        }
    }

    private String marshallNodeMapToYaml(final Map<String, Object> parentNodesMap) {
        ArrayList<Map<String, Object>> placeholder = new ArrayList<Map<String, Object>>(){
            {
                this.add(parentNodesMap);
            }
        };
        return SNAKE_YAML.dumpAs(placeholder, null, DumperOptions.FlowStyle.BLOCK);
    }

    private String marshallNodeToYaml(Object yamlNode) {
        return SNAKE_YAML.dumpAs(yamlNode, null, DumperOptions.FlowStyle.BLOCK);
    }

    private Map<String, String> configureAuthorizationHeader(Object value) {
        Map pairValue = (Map)value;
        if (pairValue.containsKey(StubAuthorizationTypes.BASIC.asYamlProp())) {
            String rawHeader = (String)pairValue.get(StubAuthorizationTypes.BASIC.asYamlProp());
            String authorizationHeader = StringUtils.isSet(rawHeader) ? rawHeader.trim() : rawHeader;
            String encodedAuthorizationHeader = String.format("%s %s", StubAuthorizationTypes.BASIC.asString(), StringUtils.encodeBase64(authorizationHeader));
            pairValue.put(StubAuthorizationTypes.BASIC.asYamlProp(), encodedAuthorizationHeader);
        } else if (pairValue.containsKey(StubAuthorizationTypes.BEARER.asYamlProp())) {
            String rawHeader = (String)pairValue.get(StubAuthorizationTypes.BEARER.asYamlProp());
            String authorizationHeader = StringUtils.isSet(rawHeader) ? rawHeader.trim() : rawHeader;
            pairValue.put(StubAuthorizationTypes.BEARER.asYamlProp(), String.format("%s %s", StubAuthorizationTypes.BEARER.asString(), authorizationHeader));
        } else if (pairValue.containsKey(StubAuthorizationTypes.CUSTOM.asYamlProp())) {
            String rawHeader = (String)pairValue.get(StubAuthorizationTypes.CUSTOM.asYamlProp());
            String authorizationHeader = StringUtils.isSet(rawHeader) ? rawHeader.trim() : rawHeader;
            pairValue.put(StubAuthorizationTypes.CUSTOM.asYamlProp(), authorizationHeader);
        }
        return pairValue;
    }
}

