/*
 * Decompiled with CFR 0.152.
 */
package by.stub.yaml.stubs;

import by.stub.annotations.VisibleForTesting;
import by.stub.utils.ReflectionUtils;
import by.stub.utils.StringUtils;
import by.stub.yaml.stubs.StubAuthorizationTypes;
import by.stub.yaml.stubs.StubRequest;
import by.stub.yaml.stubs.StubResponse;
import by.stub.yaml.stubs.StubTypes;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class StubHttpLifecycle {
    private final AtomicInteger responseSequencedIdCounter = new AtomicInteger(0);
    public static final StubHttpLifecycle NULL = null;
    private String httpLifeCycleAsYaml;
    private StubRequest request;
    private Object response = StubResponse.newStubResponse();
    private String requestAsYaml;
    private String responseAsYaml;

    public void setRequest(StubRequest request) {
        this.request = request;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public StubRequest getRequest() {
        return this.request;
    }

    public StubResponse getResponse(boolean incrementSequencedResponseId) {
        if (this.response instanceof StubResponse) {
            return (StubResponse)this.response;
        }
        LinkedList responses = (LinkedList)this.response;
        if (responses.isEmpty()) {
            return StubResponse.newStubResponse();
        }
        if (incrementSequencedResponseId) {
            int responseSequencedId = this.responseSequencedIdCounter.getAndIncrement();
            this.responseSequencedIdCounter.compareAndSet(responses.size(), 0);
            return (StubResponse)responses.get(responseSequencedId);
        }
        return (StubResponse)responses.get(this.responseSequencedIdCounter.get());
    }

    public int getNextSequencedResponseId() {
        return this.responseSequencedIdCounter.get();
    }

    public List<StubResponse> getAllResponses() {
        if (this.response instanceof StubResponse) {
            return new LinkedList<StubResponse>(){
                {
                    this.add((StubResponse)StubHttpLifecycle.this.response);
                }
            };
        }
        return (LinkedList)this.response;
    }

    public boolean isAuthorizationRequired() {
        return this.request.isSecured();
    }

    @VisibleForTesting
    String getRawAuthorizationHttpHeader() {
        return this.request.getRawAuthorizationHttpHeader();
    }

    @VisibleForTesting
    String getStubbedAuthorizationHeaderValue(StubAuthorizationTypes stubbedAuthorizationHeaderType) {
        return this.request.getStubbedAuthorizationHeaderValue(stubbedAuthorizationHeaderType);
    }

    public boolean isAssertingRequestUnauthorized(StubHttpLifecycle assertingLifecycle) {
        String stubbedAuthorizationHeaderValue = this.getStubbedAuthorizationHeaderValue(this.request.getStubbedAuthorizationTypeHeader());
        return !stubbedAuthorizationHeaderValue.equals(assertingLifecycle.getRawAuthorizationHttpHeader());
    }

    public String getResourceId() {
        return this.getAllResponses().get(0).getHeaders().get("x-stubby-resource-id");
    }

    public String getHttpLifeCycleAsYaml() {
        return this.httpLifeCycleAsYaml;
    }

    public void setHttpLifeCycleAsYaml(String httpLifeCycleAsYaml) {
        this.httpLifeCycleAsYaml = httpLifeCycleAsYaml;
    }

    public String getRequestAsYaml() {
        return this.requestAsYaml;
    }

    public void setRequestAsYaml(String requestAsYaml) {
        this.requestAsYaml = requestAsYaml;
    }

    public String getResponseAsYaml() {
        return this.responseAsYaml;
    }

    public void setResponseAsYaml(String responseAsYaml) {
        this.responseAsYaml = responseAsYaml;
    }

    public void setResourceId(int listIndex) {
        for (StubResponse response : this.getAllResponses()) {
            response.addResourceIDHeader(listIndex);
        }
    }

    public String getAjaxResponseContent(StubTypes stubType, String propertyName) throws Exception {
        switch (stubType) {
            case REQUEST: {
                return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this.request, propertyName));
            }
            case RESPONSE: {
                return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this.getResponse(false), propertyName));
            }
        }
        return StringUtils.objectToString(ReflectionUtils.getPropertyValue(this, propertyName));
    }

    public String getAjaxResponseContent(String propertyName, int sequencedResponseId) throws Exception {
        List<StubResponse> allResponses = this.getAllResponses();
        StubResponse sequencedResponse = allResponses.get(sequencedResponseId);
        return StringUtils.objectToString(ReflectionUtils.getPropertyValue(sequencedResponse, propertyName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StubHttpLifecycle)) {
            return false;
        }
        StubHttpLifecycle that = (StubHttpLifecycle)o;
        return this.request.equals(that.request);
    }
}

