/*
 * Decompiled with CFR 0.152.
 */
package c10n;

import c10n.C10N;
import c10n.C10NBundleBinder;
import c10n.C10NConfigException;
import c10n.C10NCoreModule;
import c10n.C10NFilter;
import c10n.C10NFilterProvider;
import c10n.C10NFilters;
import c10n.LocaleProvider;
import c10n.LocaleProviders;
import c10n.UntranslatedMessageHandler;
import c10n.share.EncodedResourceControl;
import c10n.share.utils.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class C10NConfigBase {
    private final C10NCoreModule coreModule = new C10NCoreModule();
    private LocaleProvider localeProvider = this.coreModule.defaultLocaleProvider();
    private UntranslatedMessageHandler untranslatedMessageHandler = this.coreModule.defaultUnknownMessageHandler();
    private final Map<String, C10NBundleBinder> bundleBinders = new HashMap<String, C10NBundleBinder>();
    private final Map<Class<?>, C10NImplementationBinder<?>> binders = new HashMap();
    private final Map<Class<? extends Annotation>, C10NAnnotationBinder> annotationBinders = new HashMap<Class<? extends Annotation>, C10NAnnotationBinder>();
    private final List<C10NFilterBinder<?>> filterBinders = new ArrayList();
    private final List<C10NConfigBase> childConfigs = new ArrayList<C10NConfigBase>();
    private String keyPrefix = "";
    private boolean debug = false;
    private boolean configured = false;

    protected abstract void configure();

    protected String getConfigurationPackage() {
        Package pkg = this.getClass().getPackage();
        return pkg != null ? pkg.getName() : "";
    }

    void doConfigure() {
        if (!this.configured) {
            this.configure();
        }
        this.configured = true;
    }

    protected void install(C10NConfigBase childConfig) {
        childConfig.doConfigure();
        this.childConfigs.add(childConfig);
    }

    protected <T> C10NImplementationBinder<T> bind(Class<T> c10nInterface) {
        C10NImplementationBinder binder = new C10NImplementationBinder();
        this.binders.put(c10nInterface, binder);
        return binder;
    }

    protected void setLocaleProvider(LocaleProvider localeProvider) {
        Preconditions.assertNotNull(localeProvider, "localeProvider");
        this.localeProvider = localeProvider;
    }

    protected void setLocale(Locale locale) {
        this.localeProvider = LocaleProviders.fixed(locale);
    }

    protected void setUntranslatedMessageHandler(UntranslatedMessageHandler handler) {
        Preconditions.assertNotNull(handler, "handler");
        this.untranslatedMessageHandler = handler;
    }

    protected C10NAnnotationBinder bindAnnotation(Class<? extends Annotation> annotationClass) {
        Preconditions.assertNotNull(annotationClass, "annotationClass");
        this.checkAnnotationInterface(annotationClass);
        C10NAnnotationBinder binder = new C10NAnnotationBinder();
        this.annotationBinders.put(annotationClass, binder);
        return binder;
    }

    protected <T> C10NFilterBinder<T> bindFilter(C10NFilterProvider<T> c10NFilterProvider, Class<T> type) {
        Preconditions.assertNotNull(c10NFilterProvider, "c10nFilterProvider");
        Preconditions.assertNotNull(type, "type");
        C10NFilterBinder filterBinder = new C10NFilterBinder(c10NFilterProvider, type);
        this.filterBinders.add(filterBinder);
        return filterBinder;
    }

    protected <T> C10NFilterBinder<T> bindFilter(C10NFilter<T> c10nFilter, Class<T> type) {
        Preconditions.assertNotNull(c10nFilter, "c10nFilter");
        Preconditions.assertNotNull(type, "type");
        C10NFilterBinder filterBinder = new C10NFilterBinder(C10NFilters.staticFilterProvider(c10nFilter), type);
        this.filterBinders.add(filterBinder);
        return filterBinder;
    }

    protected void setKeyPrefix(String key) {
        Preconditions.assertNotNull(key, "key");
        this.keyPrefix = key;
    }

    String getKeyPrefix() {
        return this.keyPrefix;
    }

    protected void setDebug(boolean debug) {
        this.debug = debug;
    }

    boolean isDebug() {
        return this.debug;
    }

    List<C10NFilterBinder<?>> getFilterBinders() {
        return this.filterBinders;
    }

    private void checkAnnotationInterface(Class<? extends Annotation> annotationClass) {
        if (this.noMethod(annotationClass, "value") && this.noMethod(annotationClass, "intRes") && this.noMethod(annotationClass, "extRes")) {
            throw new C10NConfigException("Annotation could not be bound because it's missing any of value(), intRes() or extRes() methods that return String. Please add at least one of those methods with return type of String. annotationClass=" + annotationClass.getName());
        }
    }

    private boolean noMethod(Class<? extends Annotation> annotationClass, String methodName) {
        try {
            Method valueMethod = annotationClass.getMethod(methodName, new Class[0]);
            if (!valueMethod.getReturnType().isAssignableFrom(String.class)) {
                return true;
            }
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        return false;
    }

    protected C10NBundleBinder bindBundle(String baseName) {
        C10NBundleBinder binder = new C10NBundleBinder();
        this.bundleBinders.put(baseName, binder);
        return binder;
    }

    List<ResourceBundle> getBundlesForLocale(Class<?> c10nInterface, Locale locale) {
        ArrayList<ResourceBundle> res = new ArrayList<ResourceBundle>();
        for (Map.Entry<String, C10NBundleBinder> entry : this.bundleBinders.entrySet()) {
            C10NBundleBinder binder = entry.getValue();
            if (!binder.getBoundInterfaces().isEmpty() && !binder.getBoundInterfaces().contains(c10nInterface)) continue;
            res.add(ResourceBundle.getBundle(entry.getKey(), locale, new EncodedResourceControl("UTF-8")));
        }
        return res;
    }

    Map<Class<? extends Annotation>, Set<Locale>> getAnnotationToLocaleMapping() {
        HashMap<Class<? extends Annotation>, Set<Locale>> res = new HashMap<Class<? extends Annotation>, Set<Locale>>();
        for (Map.Entry<Class<? extends Annotation>, C10NAnnotationBinder> entry : this.annotationBinders.entrySet()) {
            Set<Locale> locales = this.getLocales(entry.getKey(), res);
            locales.add(entry.getValue().getLocale());
        }
        return res;
    }

    private Set<Locale> getLocales(Class<? extends Annotation> key, Map<Class<? extends Annotation>, Set<Locale>> res) {
        Set<Locale> locales = res.get(key);
        if (null == locales) {
            locales = new HashSet<Locale>();
            res.put(key, locales);
        }
        return locales;
    }

    Class<?> getBindingForLocale(Class<?> c10nInterface, Locale locale) {
        Class<?> impl;
        C10NImplementationBinder<?> binder = this.binders.get(c10nInterface);
        if (null != binder && null != (impl = binder.getBindingForLocale(locale))) {
            return impl;
        }
        return null;
    }

    List<C10NConfigBase> getChildConfigs() {
        return this.childConfigs;
    }

    Set<Locale> getImplLocales(Class<?> c10nInterface) {
        HashSet<Locale> res = new HashSet<Locale>();
        C10NImplementationBinder<?> binder = this.binders.get(c10nInterface);
        if (binder != null) {
            res.addAll(((C10NImplementationBinder)binder).bindings.keySet());
        }
        return res;
    }

    Set<Locale> getAllImplementationBoundLocales() {
        HashSet<Locale> res = new HashSet<Locale>();
        for (C10NImplementationBinder<?> binder : this.binders.values()) {
            res.addAll(((C10NImplementationBinder)binder).bindings.keySet());
        }
        return res;
    }

    Locale getCurrentLocale() {
        return this.localeProvider.getLocale();
    }

    String getUntranslatedMessageString(Class<?> c10nInterface, Method method, Object[] methodArgs) {
        return this.untranslatedMessageHandler.render(c10nInterface, method, methodArgs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class C10NFilterBinder<T> {
        private final C10NFilterProvider<T> filter;
        private final Class<T> type;
        private final List<Class<? extends Annotation>> annotatedWith = new ArrayList<Class<? extends Annotation>>();

        private C10NFilterBinder(C10NFilterProvider<T> filter, Class<T> type) {
            this.filter = filter;
            this.type = type;
        }

        public C10NFilterBinder<T> annotatedWith(Class<? extends Annotation> annotation) {
            this.annotatedWith.add(annotation);
            return this;
        }

        C10NFilterProvider<T> getFilterProvider() {
            return this.filter;
        }

        Class<T> getType() {
            return this.type;
        }

        public List<Class<? extends Annotation>> getAnnotatedWith() {
            for (Class<? extends Annotation> clazz : this.annotatedWith) {
            }
            return this.annotatedWith;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class C10NImplementationBinder<T> {
        private final Map<Locale, Class<?>> bindings = new HashMap();

        protected C10NImplementationBinder() {
        }

        public C10NImplementationBinder<T> to(Class<? extends T> to, Locale forLocale) {
            this.bindings.put(forLocale, to);
            return this;
        }

        public C10NImplementationBinder<T> to(Class<? extends T> to) {
            this.bindings.put(C10N.FALLBACK_LOCALE, to);
            return this;
        }

        Class<?> getBindingForLocale(Locale locale) {
            return this.bindings.get(locale);
        }
    }

    protected static class C10NAnnotationBinder {
        private Locale locale = C10N.FALLBACK_LOCALE;

        protected C10NAnnotationBinder() {
        }

        public void toLocale(Locale locale) {
            Preconditions.assertNotNull(locale, "locale");
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

