/*
 * Decompiled with CFR 0.152.
 */
package c10n;

import c10n.C10NFilter;
import c10n.C10NFilterProvider;
import c10n.EnumMappingFilter;
import c10n.share.utils.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class C10NFilters {
    public static <E extends Enum<?>> C10NFilterProvider<E> enumMapping(Class<E> enumClass, Class<?> c10nMappedInterface) {
        return new EnumMappingFilterProvider<E>(enumClass, c10nMappedInterface);
    }

    public static <T> C10NFilterProvider<T> staticFilterProvider(C10NFilter<T> filter) {
        Preconditions.assertNotNull(filter, "filter");
        return new StaticC10NFilterProvider(filter);
    }

    public static <T> C10NFilterProvider<T> cachedFilterProvider(C10NFilterProvider<T> filterProvider) {
        Preconditions.assertNotNull(filterProvider, "filterProvider");
        return new CachedC10NFilterProvider(filterProvider);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumMappingFilterProvider<E extends Enum<?>>
    implements C10NFilterProvider<E> {
        private final Class<E> enumClass;
        private final Class<?> c10nMappedInterface;

        EnumMappingFilterProvider(Class<E> enumClass, Class<?> c10nMappedInterface) {
            this.enumClass = enumClass;
            this.c10nMappedInterface = c10nMappedInterface;
        }

        @Override
        public C10NFilter<E> get() {
            return new EnumMappingFilter<E>(this.enumClass, this.c10nMappedInterface);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CachedC10NFilterProvider<T>
    implements C10NFilterProvider<T> {
        private final C10NFilterProvider<T> base;
        private C10NFilter<T> thunk = null;

        private CachedC10NFilterProvider(C10NFilterProvider<T> base) {
            this.base = base;
        }

        @Override
        public C10NFilter<T> get() {
            if (null == this.thunk) {
                this.thunk = this.base.get();
            }
            return this.thunk;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StaticC10NFilterProvider<T>
    implements C10NFilterProvider<T> {
        private final C10NFilter<T> filter;

        private StaticC10NFilterProvider(C10NFilter<T> filter) {
            this.filter = filter;
        }

        @Override
        public C10NFilter<T> get() {
            return this.filter;
        }
    }
}

