/*
 * Decompiled with CFR 0.152.
 */
package c10n;

import c10n.AnnotatedClass;
import c10n.C10N;
import c10n.C10NDef;
import c10n.C10NFilterProvider;
import c10n.C10NMessages;
import c10n.ConfiguredC10NModule;
import c10n.InternalC10NMsgFactory;
import c10n.LocaleProvider;
import c10n.LocaleProviders;
import c10n.share.LocaleMapping;
import c10n.share.utils.Preconditions;
import c10n.share.utils.ReflectionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.CharBuffer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultC10NMsgFactory
implements InternalC10NMsgFactory {
    private final ConfiguredC10NModule conf;
    private final LocaleMapping localeMapping;
    private final ClassLoader proxyClassloader;

    DefaultC10NMsgFactory(ConfiguredC10NModule conf, LocaleMapping localeMapping, ClassLoader proxyClassloader) {
        this.conf = conf;
        this.localeMapping = localeMapping;
        this.proxyClassloader = proxyClassloader;
    }

    @Override
    public <T> T get(Class<T> c10nInterface) {
        Preconditions.assertNotNull(c10nInterface, "c10nInterface");
        return this.get(c10nInterface, null, new LocaleProvider(){

            public Locale getLocale() {
                return DefaultC10NMsgFactory.this.conf.getCurrentLocale();
            }
        });
    }

    @Override
    public <T> T get(Class<T> c10nInterface, Locale locale) {
        Preconditions.assertNotNull(c10nInterface, "c10nInterface");
        Preconditions.assertNotNull(locale, "locale");
        return this.get(c10nInterface, null, LocaleProviders.fixed(locale));
    }

    @Override
    public <T> T get(Class<T> c10nInterface, String delegatingValue, LocaleProvider localeProvider) {
        return (T)Proxy.newProxyInstance(this.proxyClassloader, new Class[]{c10nInterface}, (InvocationHandler)C10NInvocationHandler.create(this, delegatingValue, this.conf, localeProvider, this.localeMapping, c10nInterface));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class C10NInvocationHandler
    implements InvocationHandler {
        private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
        private final InternalC10NMsgFactory c10nFactory;
        private final String delegatingValue;
        private final ConfiguredC10NModule conf;
        private final LocaleProvider localeProvider;
        private final LocaleMapping localeMapping;
        private final Class<?> proxiedClass;
        private final Map<String, Map<Locale, C10NString>> translationsByMethod;
        private final Set<Locale> availableImplLocales;
        private final Map<AnnotatedClass, C10NFilterProvider<?>> filters;
        private final Map<Method, String> bundleKeys;

        C10NInvocationHandler(InternalC10NMsgFactory c10nFactory, String delegatingValue, ConfiguredC10NModule conf, LocaleProvider localeProvider, LocaleMapping localeMapping, Class<?> proxiedClass, Map<String, Map<Locale, C10NString>> translationsByMethod, Map<Method, String> bundleKeys) {
            this.c10nFactory = c10nFactory;
            this.delegatingValue = delegatingValue;
            this.conf = conf;
            this.localeProvider = localeProvider;
            this.localeMapping = localeMapping;
            this.proxiedClass = proxiedClass;
            this.translationsByMethod = translationsByMethod;
            this.availableImplLocales = conf.getImplementationBindings(proxiedClass);
            this.filters = conf.getFilterBindings(proxiedClass);
            this.bundleKeys = bundleKeys;
        }

        static C10NInvocationHandler create(InternalC10NMsgFactory c10nFactory, String delegatingValue, ConfiguredC10NModule conf, LocaleProvider localeProvider, LocaleMapping localeMapping, Class<?> c10nInterface) {
            HashMap<String, Map<Locale, C10NString>> translationsByMethod = new HashMap<String, Map<Locale, C10NString>>();
            HashMap<Method, String> bundleKeys = new HashMap<Method, String>();
            for (Method m : c10nInterface.getMethods()) {
                C10NDef c10nDef = m.getAnnotation(C10NDef.class);
                if (null != c10nDef) {
                    HashMap<Locale, C10NString> defMapping = new HashMap<Locale, C10NString>();
                    defMapping.put(C10N.FALLBACK_LOCALE, C10NString.def(c10nDef.value()));
                    translationsByMethod.put(m.toString(), defMapping);
                }
                String key = ReflectionUtils.getC10NKey(conf.getKeyPrefix(), m);
                if (conf.isDebug()) {
                    System.out.println("c10n: method " + ReflectionUtils.getDefaultKey(m) + " was bound to bundle key '" + key + "'");
                }
                bundleKeys.put(m, key);
            }
            for (Map.Entry<Class<? extends Annotation>, Set<Locale>> entry : conf.getAnnotationBindings(c10nInterface).entrySet()) {
                Class<? extends Annotation> annotationClass = entry.getKey();
                for (Method m : c10nInterface.getMethods()) {
                    Annotation a = m.getAnnotation(annotationClass);
                    if (null == a) continue;
                    try {
                        C10NString translation = C10NInvocationHandler.getAnnotationValue(c10nInterface, annotationClass, a);
                        HashMap<Locale, C10NString> translationsByLocale = (HashMap<Locale, C10NString>)translationsByMethod.get(m.toString());
                        if (null == translationsByLocale) {
                            translationsByLocale = new HashMap<Locale, C10NString>();
                            translationsByMethod.put(m.toString(), translationsByLocale);
                        }
                        for (Locale locale : entry.getValue()) {
                            translationsByLocale.put(locale, translation);
                        }
                    }
                    catch (SecurityException e) {
                        throw new RuntimeException("Annotation " + annotationClass.getName() + " value() method is not accessible", e);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not call value() on annotation " + annotationClass.getName(), e);
                    }
                }
            }
            return new C10NInvocationHandler(c10nFactory, delegatingValue, conf, localeProvider, localeMapping, c10nInterface, translationsByMethod, bundleKeys);
        }

        private static C10NString getAnnotationValue(Class<?> c10nInterface, Class<? extends Annotation> annotationClass, Annotation a) {
            boolean raw = C10NInvocationHandler.extractAnnotationValue(annotationClass, "raw", a, false);
            String valueTranslation = C10NInvocationHandler.extractAnnotationValue(annotationClass, "value", a, "__C10N_UNDEF__");
            if (valueTranslation.equals("__C10N_UNDEF__")) {
                String extRes = C10NInvocationHandler.extractAnnotationValue(annotationClass, "extRes", a, "__C10N_UNDEF__");
                if (extRes.equals("__C10N_UNDEF__")) {
                    String intRes = C10NInvocationHandler.extractAnnotationValue(annotationClass, "intRes", a, "__C10N_UNDEF__");
                    if (intRes.equals("__C10N_UNDEF__")) {
                        throw new RuntimeException("One of @" + annotationClass.getSimpleName() + " annotations on the " + c10nInterface.getCanonicalName() + " class does not have any of 'value' or 'extRes' or 'intRes' specified.");
                    }
                    return new C10NString(C10NInvocationHandler.readTextFromInternalResource(C10NInvocationHandler.replaceSystemProps(String.valueOf(intRes))), raw);
                }
                return new C10NString(C10NInvocationHandler.readTextFromUrl(C10NInvocationHandler.replaceSystemProps(String.valueOf(extRes))), raw);
            }
            return new C10NString(String.valueOf(valueTranslation), raw);
        }

        private static <R> R extractAnnotationValue(Class<? extends Annotation> annotationClass, String method, Annotation annotation, R defaultValue) {
            try {
                return (R)annotationClass.getMethod(method, new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (InvocationTargetException e) {
                return defaultValue;
            }
            catch (NoSuchMethodException e) {
                return defaultValue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to extract value of '" + method + "' from annotation" + "class " + annotationClass.getCanonicalName(), e);
            }
        }

        private static String replaceSystemProps(String string) {
            if (null == string) {
                return null;
            }
            String res = string;
            Pattern p = Pattern.compile("\\$\\{.*?\\}");
            Matcher m = p.matcher(string);
            while (m.find()) {
                String prop = string.substring(m.start() + 2, m.end() - 1);
                String propValue = System.getProperty(prop);
                if (propValue == null) continue;
                res = res.replace("${" + prop + "}", propValue);
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String readTextFromUrl(String urlString) {
            String string;
            block9: {
                URL url = new URL(urlString);
                InputStream is = null;
                try {
                    is = url.openStream();
                    string = C10NInvocationHandler.readTextFromInputStream(is);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (is != null) {
                                is.close();
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to read text data from URL: " + urlString, e);
                        }
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("Could not interpret external resource URL: " + urlString, e);
                    }
                }
                is.close();
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String readTextFromInternalResource(String path) {
            String string;
            block7: {
                InputStream is = null;
                try {
                    is = C10N.class.getClassLoader().getResourceAsStream(path);
                    if (null == is) {
                        throw new RuntimeException("Internal resource: " + path + " does not exist");
                    }
                    string = C10NInvocationHandler.readTextFromInputStream(is);
                    if (null == is) break block7;
                }
                catch (Throwable throwable) {
                    try {
                        if (null != is) {
                            is.close();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read text data from internal resource: " + path, e);
                    }
                }
                is.close();
            }
            return string;
        }

        private static String readTextFromInputStream(InputStream is) throws IOException {
            int read;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF8"), 8192);
            CharBuffer buf = CharBuffer.allocate(64);
            do {
                if ((read = br.read(buf)) != 0 || buf.hasRemaining()) continue;
                CharBuffer newBuf = CharBuffer.allocate(buf.capacity() * 2);
                buf.flip();
                newBuf.put(buf);
                buf = newBuf;
            } while (read != -1);
            buf.flip();
            return buf.toString();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Locale locale = this.localeProvider.getLocale();
            Locale implLocale = this.localeMapping.findClosestMatch(this.availableImplLocales, locale);
            Class<?> binding = this.conf.getImplementationBinding(this.proxiedClass, implLocale);
            if (null != binding) {
                Object instance = binding.newInstance();
                return method.invoke(instance, args);
            }
            String stringValue = this.getStringValue(method, args, locale);
            Class<String> returnType = method.getReturnType();
            if (returnType.isAssignableFrom(String.class)) {
                return stringValue;
            }
            if (returnType.isInterface() && null != returnType.getAnnotation(C10NMessages.class)) {
                return this.c10nFactory.get(returnType, stringValue, this.localeProvider);
            }
            return null;
        }

        private boolean isObjectToString(Method method, Object[] args) {
            return method.getName().equals("toString") && (args == null || args.length == 0);
        }

        private String getStringValue(Method method, Object[] args, Locale locale) {
            List<ResourceBundle> bundles = this.conf.getBundleBindings(this.proxiedClass, locale);
            for (ResourceBundle bundle : bundles) {
                String key = this.bundleKeys.get(method);
                if (null == key || !bundle.containsKey(key)) continue;
                return this.format(bundle.getString(key), method, args);
            }
            C10NString res = this.findTranslationFromAnnotations(method, locale);
            if (null == res) {
                if (this.delegatingValue != null && this.isObjectToString(method, args)) {
                    return this.delegatingValue;
                }
                return this.conf.getUntranslatedMessageString(this.proxiedClass, method, args);
            }
            return this.format(res, method, args);
        }

        private C10NString findTranslationFromAnnotations(Method method, Locale locale) {
            Map<Locale, C10NString> translationsByLocale = this.translationsByMethod.get(method.toString());
            if (null != translationsByLocale) {
                return translationsByLocale.get(this.localeMapping.findClosestMatch(translationsByLocale.keySet(), locale));
            }
            return null;
        }

        private String format(C10NString message, Method method, Object ... args) {
            return this.format(message.text, message.raw, method, args);
        }

        private String format(String message, Method method, Object ... args) {
            return this.format(message, false, method, args);
        }

        private String format(String message, boolean raw, Method method, Object ... args) {
            if (raw) {
                return message;
            }
            Annotation[][] argAnnotations = method.getParameterAnnotations();
            Class<?>[] argTypes = method.getParameterTypes();
            if (args != null && args.length > 0) {
                Object[] filteredArgs = new Object[args.length];
                for (int i = 0; i < args.length; ++i) {
                    Annotation[] annotations = argAnnotations != null ? argAnnotations[i] : NO_ANNOTATIONS;
                    filteredArgs[i] = this.applyArgFilterIfExists(annotations, argTypes[i], args[i]);
                }
                return MessageFormat.format(message, filteredArgs);
            }
            return MessageFormat.format(message, args);
        }

        private Object applyArgFilterIfExists(Annotation[] annotations, Class argType, Object arg) {
            for (Annotation annotation : annotations) {
                C10NFilterProvider<Object> filter = this.findFilterFor(argType, annotation.annotationType());
                if (null == filter) continue;
                return filter.get().apply(arg);
            }
            C10NFilterProvider<Object> filter = this.findFilterFor(argType, null);
            if (null != filter) {
                return filter.get().apply(arg);
            }
            return arg;
        }

        private C10NFilterProvider<Object> findFilterFor(Class argType, Class<? extends Annotation> annotationClass) {
            return this.filters.get(new AnnotatedClass(argType, annotationClass));
        }
    }

    private static final class C10NString {
        final String text;
        final boolean raw;

        public static C10NString def(String text) {
            return new C10NString(text, false);
        }

        private C10NString(String text, boolean raw) {
            this.text = text;
            this.raw = raw;
        }
    }
}

