/*
 * Decompiled with CFR 0.152.
 */
package c10n;

import c10n.C10NConfigBase;
import c10n.ConfigChainResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigChainResolver
implements ConfigChainResolver {
    private static final Comparator<C10NConfigBase> cmpByConfPkgName = new C10NConfigBaseComparator();
    private final C10NConfigBase parentConfig;

    public DefaultConfigChainResolver(C10NConfigBase parentConfig) {
        this.parentConfig = parentConfig;
    }

    @Override
    public List<C10NConfigBase> resolve(Class<?> c10nInterface) {
        ArrayList<C10NConfigBase> res = new ArrayList<C10NConfigBase>();
        this.traverse(this.parentConfig, c10nInterface, res);
        Collections.sort(res, cmpByConfPkgName);
        return res;
    }

    private void traverse(C10NConfigBase config, Class<?> c10nInterface, List<C10NConfigBase> result) {
        result.add(config);
        for (C10NConfigBase childConfig : config.getChildConfigs()) {
            if (!this.isPackageAncestorOf(childConfig, c10nInterface)) continue;
            this.traverse(childConfig, c10nInterface, result);
        }
    }

    private boolean isPackageAncestorOf(C10NConfigBase config, Class<?> c10nInterface) {
        String c10nPackage = c10nInterface.getPackage().getName();
        String configPackage = config.getConfigurationPackage();
        return c10nPackage.startsWith(configPackage);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class C10NConfigBaseComparator
    implements Comparator<C10NConfigBase> {
        private C10NConfigBaseComparator() {
        }

        @Override
        public int compare(C10NConfigBase o1, C10NConfigBase o2) {
            int cmp = -1 * o1.getConfigurationPackage().compareTo(o2.getConfigurationPackage());
            if (0 == cmp) {
                cmp = o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
            }
            return cmp;
        }
    }
}

