/*
 * Decompiled with CFR 0.152.
 */
package c10n;

import c10n.AnnotatedClass;
import c10n.C10NConfigBase;
import c10n.C10NFilterProvider;
import c10n.ConfigChainResolver;
import c10n.ConfiguredC10NModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultConfiguredC10NModule
implements ConfiguredC10NModule {
    private final C10NConfigBase parentConfig;
    private final ConfigChainResolver configResolver;

    DefaultConfiguredC10NModule(C10NConfigBase parentConfig, ConfigChainResolver configResolver) {
        this.parentConfig = parentConfig;
        this.configResolver = configResolver;
    }

    @Override
    public Locale getCurrentLocale() {
        return this.parentConfig.getCurrentLocale();
    }

    @Override
    public Map<Class<? extends Annotation>, Set<Locale>> getAnnotationBindings(Class<?> c10nInterface) {
        HashMap<Class<? extends Annotation>, Set<Locale>> res = new HashMap<Class<? extends Annotation>, Set<Locale>>();
        List<C10NConfigBase> configChain = this.configResolver.resolve(c10nInterface);
        Collections.reverse(configChain);
        for (C10NConfigBase config : configChain) {
            res.putAll(config.getAnnotationToLocaleMapping());
        }
        return res;
    }

    @Override
    public Set<Locale> getImplementationBindings(Class<?> c10nInterface) {
        HashSet<Locale> res = new HashSet<Locale>();
        List<C10NConfigBase> configChain = this.configResolver.resolve(c10nInterface);
        for (C10NConfigBase config : configChain) {
            res.addAll(config.getImplLocales(c10nInterface));
        }
        return res;
    }

    @Override
    public Class<?> getImplementationBinding(Class<?> c10nInterface, Locale locale) {
        List<C10NConfigBase> configChain = this.configResolver.resolve(c10nInterface);
        for (C10NConfigBase config : configChain) {
            Class<?> impl = config.getBindingForLocale(c10nInterface, locale);
            if (null == impl) continue;
            return impl;
        }
        return null;
    }

    @Override
    public List<ResourceBundle> getBundleBindings(Class<?> c10nInterface, Locale locale) {
        ArrayList<ResourceBundle> res = new ArrayList<ResourceBundle>();
        List<C10NConfigBase> configChain = this.configResolver.resolve(c10nInterface);
        for (C10NConfigBase config : configChain) {
            res.addAll(config.getBundlesForLocale(c10nInterface, locale));
        }
        return res;
    }

    @Override
    public Map<AnnotatedClass, C10NFilterProvider<?>> getFilterBindings(Class<?> c10nInterface) {
        List<C10NConfigBase> configChain = this.configResolver.resolve(c10nInterface);
        HashMap res = new HashMap();
        Collections.reverse(configChain);
        for (C10NConfigBase config : configChain) {
            for (C10NConfigBase.C10NFilterBinder<?> filterBinder : config.getFilterBinders()) {
                if (filterBinder.getAnnotatedWith().isEmpty()) {
                    res.put(new AnnotatedClass(filterBinder.getType(), null), filterBinder.getFilterProvider());
                    continue;
                }
                for (Class<Annotation> annotation : filterBinder.getAnnotatedWith()) {
                    res.put(new AnnotatedClass(filterBinder.getType(), annotation), filterBinder.getFilterProvider());
                }
            }
        }
        return res;
    }

    @Override
    public String getUntranslatedMessageString(Class<?> c10nInterface, Method method, Object[] methodArgs) {
        return this.parentConfig.getUntranslatedMessageString(c10nInterface, method, methodArgs);
    }

    @Override
    public String getKeyPrefix() {
        return this.parentConfig.getKeyPrefix();
    }

    @Override
    public boolean isDebug() {
        return this.parentConfig.isDebug();
    }

    @Override
    public Set<Locale> getAllBoundLocales() {
        HashSet<Locale> res = new HashSet<Locale>();
        for (C10NConfigBase config : this.traverseConfigs(this.parentConfig)) {
            res.addAll(config.getAllImplementationBoundLocales());
            for (Set<Locale> locales : config.getAnnotationToLocaleMapping().values()) {
                res.addAll(locales);
            }
        }
        return res;
    }

    private List<C10NConfigBase> traverseConfigs(C10NConfigBase config) {
        ArrayList<C10NConfigBase> res = new ArrayList<C10NConfigBase>();
        this.traverseConfigs(config, res);
        return res;
    }

    private void traverseConfigs(C10NConfigBase config, List<C10NConfigBase> result) {
        result.add(config);
        for (C10NConfigBase childConfig : config.getChildConfigs()) {
            this.traverseConfigs(childConfig, result);
        }
    }
}

