/*
 * Decompiled with CFR 0.152.
 */
package c10n;

import c10n.C10N;
import c10n.C10NFilter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EnumMappingFilter<E extends Enum<?>>
implements C10NFilter<E> {
    private final Object enumC10NInterfaceInstance;
    private final Map<Enum<?>, Method> c10nInfMethodMapping;

    EnumMappingFilter(Class<E> enumClass, Class<?> c10nInterface) {
        this.enumC10NInterfaceInstance = C10N.get(c10nInterface);
        this.c10nInfMethodMapping = EnumMappingFilter.genMapping(enumClass, c10nInterface);
    }

    private static <E extends Enum<?>> Map<Enum<?>, Method> genMapping(Class<E> enumClass, Class<?> enumC10NInterface) {
        HashMap<String, Method> allMethods = new HashMap<String, Method>();
        for (Method m : enumC10NInterface.getMethods()) {
            allMethods.put(m.getName().toLowerCase(), m);
        }
        HashMap res = new HashMap();
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            Method m = (Method)allMethods.get(enumClass.getSimpleName().toLowerCase() + "_" + enumValue.name().toLowerCase());
            if ((null == m || EnumMappingFilter.hasOneOrMoreParams(m) || EnumMappingFilter.returnsNonObjectType(m)) && (null == (m = (Method)allMethods.get(enumValue.name().toLowerCase())) || EnumMappingFilter.hasOneOrMoreParams(m) || EnumMappingFilter.returnsNonObjectType(m))) {
                throw new IllegalStateException("method mapping for " + enumClass.getSimpleName() + "." + enumValue.name() + " was not found!!");
            }
            res.put(enumValue, m);
        }
        return res;
    }

    private static boolean returnsNonObjectType(Method m) {
        return m.getReturnType().equals(Void.TYPE);
    }

    private static boolean hasOneOrMoreParams(Method m) {
        Class<?>[] paramTypes = m.getParameterTypes();
        return paramTypes != null && paramTypes.length != 0;
    }

    @Override
    public Object apply(E arg) {
        Method m = this.c10nInfMethodMapping.get(arg);
        try {
            return m.invoke(this.enumC10NInterfaceInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dispatch invocation to " + m.getDeclaringClass().getSimpleName() + "." + m.getName() + "() method.", e);
        }
    }
}

