/*
 * Decompiled with CFR 0.152.
 */
package c10n.share;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class EncodedResourceControl
extends ResourceBundle.Control {
    private final String charsetName;

    public EncodedResourceControl(String charsetName) {
        this.charsetName = charsetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (format.equals("java.properties")) {
            InputStream stream;
            String bundleName = this.toBundleName(baseName, locale);
            final String resourceName = this.toResourceName(bundleName, "properties");
            final ClassLoader classLoader = loader;
            final boolean reloadFlag = reload;
            try {
                stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        InputStream is = null;
                        if (reloadFlag) {
                            URLConnection connection;
                            URL url = classLoader.getResource(resourceName);
                            if (url != null && (connection = url.openConnection()) != null) {
                                connection.setUseCaches(false);
                                is = connection.getInputStream();
                            }
                        } else {
                            is = classLoader.getResourceAsStream(resourceName);
                        }
                        return is;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(stream, this.charsetName));
                return propertyResourceBundle;
            }
            finally {
                stream.close();
            }
        }
        return super.newBundle(baseName, locale, format, loader, reload);
    }
}

