/*
 * Decompiled with CFR 0.152.
 */
package c10n.share.utils;

import c10n.C10NKey;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final String KEY_DELIM = ".";

    public static String getC10NKey(String keyPrefix, Method method) {
        String key = ReflectionUtils.getKeyAnnotationBasedKey(method);
        if (null == key) {
            key = ReflectionUtils.getDefaultKey(method);
        }
        if (keyPrefix.length() > 0) {
            key = keyPrefix + KEY_DELIM + key;
        }
        return key;
    }

    public static String getKeyAnnotationBasedKey(Method method) {
        String methodKey;
        String parentKey = ReflectionUtils.findParentKey(method);
        String c10NKey = ReflectionUtils.getKeyAnnotationValue(method);
        if (null == parentKey && null == c10NKey) {
            return null;
        }
        if (null != c10NKey) {
            methodKey = c10NKey;
            if (methodKey.startsWith(KEY_DELIM)) {
                return methodKey.substring(1, methodKey.length());
            }
        } else {
            methodKey = ReflectionUtils.getMethodKey(method);
        }
        if (parentKey != null) {
            return parentKey + KEY_DELIM + methodKey;
        }
        return methodKey;
    }

    public static String getKeyAnnotationValue(Method method) {
        C10NKey c10NKey = method.getAnnotation(C10NKey.class);
        if (null != c10NKey) {
            return c10NKey.value();
        }
        return null;
    }

    public static String getDefaultKey(Method method) {
        StringBuilder sb = new StringBuilder();
        ReflectionUtils.getDefaultKey(method, sb);
        return sb.toString();
    }

    public static void getDefaultKey(Method method, StringBuilder sb) {
        ReflectionUtils.getFQNString(method.getDeclaringClass(), sb);
        sb.append(KEY_DELIM);
        ReflectionUtils.getMethodKey(method, sb);
    }

    private static String getMethodKey(Method method) {
        StringBuilder sb = new StringBuilder();
        ReflectionUtils.getMethodKey(method, sb);
        return sb.toString();
    }

    private static void getMethodKey(Method method, StringBuilder sb) {
        sb.append(method.getName());
        Class<?>[] params = method.getParameterTypes();
        if (params.length > 0) {
            sb.append('_');
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i].getSimpleName());
                if (i + 1 >= params.length) continue;
                sb.append("_");
            }
        }
    }

    public static String getFQNString(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        ReflectionUtils.getFQNString(clazz, sb);
        return sb.toString();
    }

    public static void getFQNString(Class<?> clazz, StringBuilder sb) {
        sb.append(clazz.getPackage().getName()).append(KEY_DELIM);
        ReflectionUtils.getClassFQNString(clazz, sb);
    }

    private static void getClassFQNString(Class<?> clazz, StringBuilder sb) {
        Iterator<Class<?>> it = ReflectionUtils.typeEnclosureHierarchy(clazz).descendingIterator();
        while (it.hasNext()) {
            sb.append(it.next().getSimpleName());
            if (!it.hasNext()) continue;
            sb.append(KEY_DELIM);
        }
    }

    private static String findParentKey(Method method) {
        for (Class<?> clazz : ReflectionUtils.expandInterfaceHierarchy(method.getDeclaringClass())) {
            C10NKey key = clazz.getAnnotation(C10NKey.class);
            if (null == key) continue;
            return key.value();
        }
        return null;
    }

    private static LinkedList<Class<?>> typeEnclosureHierarchy(Class<?> clazz) {
        LinkedList typeHierarchy = new LinkedList();
        do {
            typeHierarchy.add(clazz);
        } while ((clazz = clazz.getEnclosingClass()) != null);
        return typeHierarchy;
    }

    private static List<Class<?>> expandInterfaceHierarchy(Class<?> clazz) {
        ArrayList res = new ArrayList();
        res.add(clazz);
        ReflectionUtils.expandInterfaceHierarchy(clazz, res);
        return res;
    }

    private static void expandInterfaceHierarchy(Class<?> clazz, List<Class<?>> res) {
        Class<?>[] intfs = clazz.getInterfaces();
        if (null != intfs) {
            Collections.addAll(res, intfs);
            for (Class<?> intf : intfs) {
                ReflectionUtils.expandInterfaceHierarchy(intf, res);
            }
        }
    }
}

