/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.AbstractJavaccTask;
import java.io.File;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;

public class JavaccSourceFileVisitor
extends EmptyFileVisitor {
    private AbstractJavaccTask task;

    public JavaccSourceFileVisitor(AbstractJavaccTask task) {
        this.task = task;
    }

    public void visitFile(FileVisitDetails fileDetails) {
        if (this.isValidSourceFileForTask(fileDetails)) {
            this.task.compile(this.computeInputDirectory(fileDetails), fileDetails.getRelativePath());
        } else {
            this.task.getLogger().debug("Skipping file {} as it is not supported by program {}", (Object)fileDetails.getFile().getAbsolutePath(), (Object)this.task.getProgramName());
        }
    }

    private boolean isValidSourceFileForTask(FileVisitDetails fileDetails) {
        return fileDetails.getName().toLowerCase().endsWith(this.task.supportedSuffix());
    }

    private File computeInputDirectory(FileVisitDetails fileVisitDetails) {
        File fileAbsolute = fileVisitDetails.getFile();
        File fileRelative = new File(fileVisitDetails.getPath());
        return new File(fileAbsolute.getAbsolutePath().replace(fileRelative.getPath(), ""));
    }
}

