/*
 * Decompiled with CFR 0.152.
 */
package ca.coglinc.gradle.plugins.javacc;

import ca.coglinc.gradle.plugins.javacc.AbstractJavaccTask;
import ca.coglinc.gradle.plugins.javacc.JavaccTaskException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;

public class NonJavaccSourceFileVisitor
extends EmptyFileVisitor {
    private AbstractJavaccTask task;

    public NonJavaccSourceFileVisitor(AbstractJavaccTask abstractJavaccTask) {
        this.task = abstractJavaccTask;
    }

    public void visitFile(FileVisitDetails fileDetails) {
        if (!this.isValidSourceFileForTask(fileDetails)) {
            File sourceFile = fileDetails.getFile();
            File destinationFile = new File(sourceFile.getAbsolutePath().replace(this.task.getInputDirectory().getAbsolutePath(), this.task.getOutputDirectory().getAbsolutePath()));
            this.copyFile(sourceFile, destinationFile);
        }
    }

    private void copyFile(File sourceFile, File destinationFile) {
        this.task.getLogger().debug("Copying non javacc source file from {} to {}", (Object)sourceFile.getAbsolutePath(), (Object)destinationFile.getAbsolutePath());
        try {
            FileUtils.copyFile((File)sourceFile, (File)destinationFile);
        }
        catch (IOException e) {
            throw new JavaccTaskException(String.format("Could not copy file %s to %s", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()), e);
        }
    }

    private boolean isValidSourceFileForTask(FileVisitDetails fileDetails) {
        return fileDetails.getName().toLowerCase().endsWith(this.task.supportedSuffix());
    }
}

