/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.Term;
import polyglot.ext.jl.ast.Assign_c;
import polyglot.types.ClassType;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;

public class FieldAssign_c
extends Assign_c
implements FieldAssign {
    public FieldAssign_c(Position pos, Field left, Assign.Operator op, Expr right) {
        super(pos, left, op, right);
    }

    public Assign left(Expr left) {
        FieldAssign_c n = (FieldAssign_c)super.left(left);
        n.assertLeftType();
        return n;
    }

    private void assertLeftType() {
        if (!(this.left() instanceof Field)) {
            throw new InternalCompilerError("left expression of an FieldAssign must be a field");
        }
    }

    public Term entry() {
        Field f = (Field)this.left();
        if (f.target() instanceof Expr) {
            return ((Expr)f.target()).entry();
        }
        if (this.operator() != Assign.ASSIGN) {
            return f;
        }
        return this.right().entry();
    }

    protected void acceptCFGAssign(CFGBuilder v) {
        Field f = (Field)this.left();
        if (f.target() instanceof Expr) {
            Expr o = (Expr)f.target();
            v.visitCFG((Term)o, this.right().entry());
            v.visitCFG((Term)this.right(), this);
        } else {
            v.visitCFG((Term)this.right(), this);
        }
    }

    protected void acceptCFGOpAssign(CFGBuilder v) {
        Field f = (Field)this.left();
        if (f.target() instanceof Expr) {
            Expr o = (Expr)f.target();
            v.visitCFG((Term)o, f);
            v.visitThrow(f);
            v.edge(f, this.right().entry());
            v.visitCFG((Term)this.right(), this);
        } else {
            v.visitThrow(f);
            v.edge(f, this.right().entry());
            v.visitCFG((Term)this.right(), this);
        }
    }

    public List throwTypes(TypeSystem ts) {
        ArrayList<ClassType> l = new ArrayList<ClassType>(super.throwTypes(ts));
        Field f = (Field)this.left();
        if (f.target() instanceof Expr) {
            l.add(ts.NullPointerException());
        }
        return l;
    }
}

