/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import polyglot.main.Report;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Base64;
import polyglot.util.InternalCompilerError;
import polyglot.util.TypeInputStream;
import polyglot.util.TypeOutputStream;

public class TypeEncoder {
    protected TypeSystem ts;
    protected final boolean zip = false;
    protected final boolean base64 = true;
    protected final boolean test = false;

    public TypeEncoder(TypeSystem ts) {
        this.ts = ts;
    }

    public String encode(Type t) throws IOException {
        if (Report.should_report("serialize", 1)) {
            Report.report(1, "Encoding type " + t);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TypeOutputStream oos = new TypeOutputStream(baos, this.ts, t);
        oos.writeObject(t);
        oos.flush();
        oos.close();
        byte[] b = baos.toByteArray();
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "Size of serialization (without zipping) is " + b.length + " bytes");
        }
        String s = new String(Base64.encode(b));
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "Size of serialization after conversion to string is " + s.length() + " characters");
        }
        return s;
    }

    public Type decode(String s) throws InvalidClassException {
        byte[] b = Base64.decode(s.toCharArray());
        try {
            TypeInputStream ois = new TypeInputStream(new ByteArrayInputStream(b), this.ts);
            return (Type)ois.readObject();
        }
        catch (InvalidClassException e) {
            throw e;
        }
        catch (IOException e) {
            throw new InternalCompilerError("IOException thrown while decoding serialized type info: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError("Unable to find one of the classes for the serialized type info: " + e.getMessage(), e);
        }
    }
}

