/*
 * Decompiled with CFR 0.152.
 */
package ca.rmen.sunrisesunset;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public final class SunriseSunset {
    public static final double SUN_ALTITUDE_SUNRISE_SUNSET = -0.833;
    public static final double SUN_ALTITUDE_CIVIL_TWILIGHT = -6.0;
    public static final double SUN_ALTITUDE_NAUTICAL_TWILIGHT = -12.0;
    public static final double SUN_ALTITUDE_ASTRONOMICAL_TWILIGHT = -18.0;
    private static final int JULIAN_DATE_2000_01_01 = 2451545;
    private static final double CONST_0009 = 9.0E-4;
    private static final double CONST_360 = 360.0;
    private static final long MILLISECONDS_IN_DAY = 86400000L;

    private SunriseSunset() {
    }

    public static double getJulianDate(Calendar gregorianDate) {
        TimeZone tzUTC = TimeZone.getTimeZone("UTC");
        Calendar gregorianDateUTC = Calendar.getInstance(tzUTC);
        gregorianDateUTC.setTimeInMillis(gregorianDate.getTimeInMillis());
        int year = gregorianDateUTC.get(1);
        int month = gregorianDateUTC.get(2) + 1;
        int day = gregorianDateUTC.get(5);
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        int julianDay = day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
        int hour = gregorianDateUTC.get(11);
        int minute = gregorianDateUTC.get(12);
        int second = gregorianDateUTC.get(13);
        return (double)julianDay + ((double)hour - 12.0) / 24.0 + (double)minute / 1440.0 + (double)second / 86400.0;
    }

    public static Calendar getGregorianDate(double julianDate) {
        int DAYS_PER_4000_YEARS = 146097;
        int DAYS_PER_CENTURY = 36524;
        int DAYS_PER_4_YEARS = 1461;
        int DAYS_PER_5_MONTHS = 153;
        int J = (int)(julianDate + 0.5);
        int j = J + 32044;
        int g = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m + 2) / 12;
        int month = (m + 2) % 12;
        int day = d + 1;
        double dayFraction = julianDate + 0.5 - (double)J;
        int hours = (int)(dayFraction * 24.0);
        int minutes = (int)((dayFraction * 24.0 - (double)hours) * 60.0);
        int seconds = (int)(dayFraction * 24.0 * 3600.0 - (double)(hours * 3600 + minutes * 60) + 0.5);
        Calendar gregorianDateUTC = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        gregorianDateUTC.set(1, year);
        gregorianDateUTC.set(2, month);
        gregorianDateUTC.set(5, day);
        gregorianDateUTC.set(11, hours);
        gregorianDateUTC.set(12, minutes);
        gregorianDateUTC.set(13, seconds);
        gregorianDateUTC.set(14, 0);
        Calendar gregorianDate = Calendar.getInstance();
        gregorianDate.setTimeInMillis(gregorianDateUTC.getTimeInMillis());
        return gregorianDate;
    }

    public static Calendar[] getCivilTwilight(Calendar day, double latitude, double longitude) {
        return SunriseSunset.getSunriseSunset(day, latitude, longitude, -6.0);
    }

    public static Calendar[] getNauticalTwilight(Calendar day, double latitude, double longitude) {
        return SunriseSunset.getSunriseSunset(day, latitude, longitude, -12.0);
    }

    public static Calendar[] getAstronomicalTwilight(Calendar day, double latitude, double longitude) {
        return SunriseSunset.getSunriseSunset(day, latitude, longitude, -18.0);
    }

    public static Calendar[] getSunriseSunset(Calendar day, double latitude, double longitude) {
        return SunriseSunset.getSunriseSunset(day, latitude, longitude, -0.833);
    }

    private static SolarEquationVariables getSolarEquationVariables(Calendar day, double longitude) {
        longitude = -longitude;
        double julianDate = SunriseSunset.getJulianDate(day);
        double nstar = julianDate - 2451545.0 - 9.0E-4 - longitude / 360.0;
        double n = Math.round(nstar);
        double jstar = 2451545.0009 + longitude / 360.0 + n;
        double m = Math.toRadians((357.5291 + 0.98560028 * (jstar - 2451545.0)) % 360.0);
        double c = 1.9148 * Math.sin(m) + 0.02 * Math.sin(2.0 * m) + 3.0E-4 * Math.sin(3.0 * m);
        double lambda = Math.toRadians((Math.toDegrees(m) + 102.9372 + c + 180.0) % 360.0);
        double jtransit = jstar + 0.0053 * Math.sin(m) - 0.0069 * Math.sin(2.0 * lambda);
        double delta = Math.asin(Math.sin(lambda) * Math.sin(Math.toRadians(23.439)));
        return new SolarEquationVariables(n, m, lambda, jtransit, delta);
    }

    public static Calendar[] getSunriseSunset(Calendar day, double latitude, double longitude, double sunAltitude) {
        SolarEquationVariables solarEquationVariables = SunriseSunset.getSolarEquationVariables(day, longitude);
        longitude = -longitude;
        double latitudeRad = Math.toRadians(latitude);
        double omega = Math.acos((Math.sin(Math.toRadians(sunAltitude)) - Math.sin(latitudeRad) * Math.sin(solarEquationVariables.delta)) / (Math.cos(latitudeRad) * Math.cos(solarEquationVariables.delta)));
        if (Double.isNaN(omega)) {
            return null;
        }
        double jset = 2451545.0009 + ((Math.toDegrees(omega) + longitude) / 360.0 + solarEquationVariables.n + 0.0053 * Math.sin(solarEquationVariables.m) - 0.0069 * Math.sin(2.0 * solarEquationVariables.lambda));
        double jrise = solarEquationVariables.jtransit - (jset - solarEquationVariables.jtransit);
        Calendar gregRiseUTC = SunriseSunset.getGregorianDate(jrise);
        Calendar gregSetUTC = SunriseSunset.getGregorianDate(jset);
        Calendar gregRise = Calendar.getInstance(day.getTimeZone());
        gregRise.setTimeInMillis(gregRiseUTC.getTimeInMillis());
        Calendar gregSet = Calendar.getInstance(day.getTimeZone());
        gregSet.setTimeInMillis(gregSetUTC.getTimeInMillis());
        return new Calendar[]{gregRise, gregSet};
    }

    public static Calendar getSolarNoon(Calendar day, double latitude, double longitude) {
        SolarEquationVariables solarEquationVariables = SunriseSunset.getSolarEquationVariables(day, longitude);
        double latitudeRad = Math.toRadians(latitude);
        double omega = Math.acos((Math.sin(Math.toRadians(-0.833)) - Math.sin(latitudeRad) * Math.sin(solarEquationVariables.delta)) / (Math.cos(latitudeRad) * Math.cos(solarEquationVariables.delta)));
        if (Double.isNaN(omega)) {
            return null;
        }
        Calendar gregNoonUTC = SunriseSunset.getGregorianDate(solarEquationVariables.jtransit);
        Calendar gregNoon = Calendar.getInstance(day.getTimeZone());
        gregNoon.setTimeInMillis(gregNoonUTC.getTimeInMillis());
        return gregNoon;
    }

    public static boolean isDay(double latitude, double longitude) {
        Calendar now = Calendar.getInstance();
        return SunriseSunset.isDay(now, latitude, longitude);
    }

    public static boolean isDay(Calendar calendar, double latitude, double longitude) {
        Calendar[] sunriseSunset = SunriseSunset.getSunriseSunset(calendar, latitude, longitude);
        if (sunriseSunset == null) {
            int month = calendar.get(2);
            if (latitude > 0.0) {
                return month >= 3 && month <= 10;
            }
            return month < 3 || month > 10;
        }
        Calendar sunrise = sunriseSunset[0];
        Calendar sunset = sunriseSunset[1];
        return calendar.after(sunrise) && calendar.before(sunset);
    }

    public static boolean isNight(double latitude, double longitude) {
        Calendar now = Calendar.getInstance();
        return SunriseSunset.isNight(now, latitude, longitude);
    }

    public static boolean isNight(Calendar calendar, double latitude, double longitude) {
        Calendar[] astronomicalTwilight = SunriseSunset.getAstronomicalTwilight(calendar, latitude, longitude);
        if (astronomicalTwilight == null) {
            int month = calendar.get(2);
            if (latitude > 0.0) {
                return month < 3 || month > 10;
            }
            return month >= 3 && month <= 10;
        }
        Calendar dawn = astronomicalTwilight[0];
        Calendar dusk = astronomicalTwilight[1];
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
        format.setTimeZone(calendar.getTimeZone());
        return calendar.before(dawn) || calendar.after(dusk);
    }

    public static boolean isCivilTwilight(double latitude, double longitude) {
        Calendar today = Calendar.getInstance();
        return SunriseSunset.isCivilTwilight(today, latitude, longitude);
    }

    public static boolean isCivilTwilight(Calendar calendar, double latitude, double longitude) {
        Calendar[] sunriseSunset = SunriseSunset.getSunriseSunset(calendar, latitude, longitude);
        if (sunriseSunset == null) {
            return false;
        }
        Calendar[] civilTwilight = SunriseSunset.getCivilTwilight(calendar, latitude, longitude);
        if (civilTwilight == null) {
            return false;
        }
        return calendar.after(sunriseSunset[1]) && calendar.before(civilTwilight[1]) || calendar.after(civilTwilight[0]) && calendar.before(sunriseSunset[0]);
    }

    public static boolean isNauticalTwilight(double latitude, double longitude) {
        Calendar today = Calendar.getInstance();
        return SunriseSunset.isNauticalTwilight(today, latitude, longitude);
    }

    public static boolean isNauticalTwilight(Calendar calendar, double latitude, double longitude) {
        Calendar[] civilTwilight = SunriseSunset.getCivilTwilight(calendar, latitude, longitude);
        if (civilTwilight == null) {
            return false;
        }
        Calendar[] nauticalTwilight = SunriseSunset.getNauticalTwilight(calendar, latitude, longitude);
        if (nauticalTwilight == null) {
            return false;
        }
        return calendar.after(civilTwilight[1]) && calendar.before(nauticalTwilight[1]) || calendar.after(nauticalTwilight[0]) && calendar.before(civilTwilight[0]);
    }

    public static boolean isAstronomicalTwilight(double latitude, double longitude) {
        Calendar today = Calendar.getInstance();
        return SunriseSunset.isAstronomicalTwilight(today, latitude, longitude);
    }

    public static boolean isAstronomicalTwilight(Calendar calendar, double latitude, double longitude) {
        Calendar[] nauticalTwilight = SunriseSunset.getNauticalTwilight(calendar, latitude, longitude);
        if (nauticalTwilight == null) {
            return false;
        }
        Calendar[] astronomicalTwilight = SunriseSunset.getAstronomicalTwilight(calendar, latitude, longitude);
        if (astronomicalTwilight == null) {
            return false;
        }
        return calendar.after(nauticalTwilight[1]) && calendar.before(astronomicalTwilight[1]) || calendar.after(astronomicalTwilight[0]) && calendar.before(nauticalTwilight[0]);
    }

    public static boolean isTwilight(double latitude, double longitude) {
        Calendar today = Calendar.getInstance();
        return SunriseSunset.isTwilight(today, latitude, longitude);
    }

    public static boolean isTwilight(Calendar calendar, double latitude, double longitude) {
        return SunriseSunset.isCivilTwilight(calendar, latitude, longitude) || SunriseSunset.isNauticalTwilight(calendar, latitude, longitude) || SunriseSunset.isAstronomicalTwilight(calendar, latitude, longitude);
    }

    public static DayPeriod getDayPeriod(Calendar calendar, double latitude, double longitude) {
        if (SunriseSunset.isDay(calendar, latitude, longitude)) {
            return DayPeriod.DAY;
        }
        if (SunriseSunset.isCivilTwilight(calendar, latitude, longitude)) {
            return DayPeriod.CIVIL_TWILIGHT;
        }
        if (SunriseSunset.isNauticalTwilight(calendar, latitude, longitude)) {
            return DayPeriod.NAUTICAL_TWILIGHT;
        }
        if (SunriseSunset.isAstronomicalTwilight(calendar, latitude, longitude)) {
            return DayPeriod.ASTRONOMICAL_TWILIGHT;
        }
        if (SunriseSunset.isNight(calendar, latitude, longitude)) {
            return DayPeriod.NIGHT;
        }
        return DayPeriod.NIGHT;
    }

    public static long getDayLength(Calendar calendar, double latitude, double longitude) {
        Calendar[] sunriseSunset = SunriseSunset.getSunriseSunset(calendar, latitude, longitude);
        if (sunriseSunset == null) {
            int month = calendar.get(2);
            if (latitude > 0.0) {
                if (month >= 3 && month <= 10) {
                    return 86400000L;
                }
                return 0L;
            }
            if (month >= 3 && month <= 10) {
                return 0L;
            }
            return 86400000L;
        }
        return sunriseSunset[1].getTimeInMillis() - sunriseSunset[0].getTimeInMillis();
    }

    private static class SolarEquationVariables {
        final double n;
        final double m;
        final double lambda;
        final double jtransit;
        final double delta;

        private SolarEquationVariables(double n, double m, double lambda, double jtransit, double delta) {
            this.n = n;
            this.m = m;
            this.lambda = lambda;
            this.jtransit = jtransit;
            this.delta = delta;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DayPeriod {
        DAY,
        CIVIL_TWILIGHT,
        NAUTICAL_TWILIGHT,
        ASTRONOMICAL_TWILIGHT,
        NIGHT;

    }
}

