/*
 * Colonel -- a brigadier expansion library
 * Copyright (C) zml and Colonel contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.colonel.impl;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class Colonel implements ModInitializer {
    private static final String MOD_FAPI_NETWORKING = "fabric-networking-v0";

    static class_2960 id(final String value) {
        return new class_2960("colonel", value);
    }

    @Override
    public void onInitialize() {
        // sync is optional, so fapi is not required
        if (FabricLoader.getInstance().isModLoaded(MOD_FAPI_NETWORKING)) {
            RegisteredArgumentTypesC2SPacket.register();
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) { // we need to send the packet
                C2SPlayChannelEvents.REGISTER.register((handler, sender, client, channels) -> {
                    if (channels.contains(RegisteredArgumentTypesC2SPacket.ID)) {
                        client.execute(() -> RegisteredArgumentTypesC2SPacket.of(ServerArgumentTypes.getIds()).sendTo(sender));
                    }
                });
            }
        }
    }
}
