/*
 * Colonel -- a brigadier expansion library
 * Copyright (C) zml and Colonel contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ca.stellardrift.colonel.impl;

import ca.stellardrift.colonel.api.ServerArgumentType;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

import static java.util.Objects.requireNonNull;

public class ServerArgumentTypes {
    private static final Map<Class<?>, ServerArgumentType<?>> BY_TYPE = new HashMap<>();
    private static final Map<class_2960, ServerArgumentType<?>> BY_ID = new ConcurrentHashMap<>();

    @SuppressWarnings("unchecked")
    public static <T extends ArgumentType<?>> ServerArgumentType<T> byClass(final Class<T> clazz) {
        return (ServerArgumentType<T>)BY_TYPE.get(requireNonNull(clazz, "clazz"));
    }

    public static void register(final ServerArgumentType<?> type) {
        BY_TYPE.put(type.type(), type);
        BY_ID.put(type.id(), type);
    }

    public static Set<class_2960> getIds() {
        return Collections.unmodifiableSet(BY_ID.keySet());
    }

    public static void setKnownArgumentTypes(final class_1657 player, final Set<class_2960> ids) {
        if(player instanceof class_3222) {
            final class_3222 spe = (class_3222) player;
            ((ServerPlayerBridge) player).colonel$knownArguments(ids);
            if (!ids.isEmpty()) { // TODO: Avoid resending the whole command tree, find a way to receive the packet before sending?
                spe.field_13995.method_3760().method_14576(spe);
            }
        }
    }

    public static Set<class_2960> getKnownArgumentTypes(final class_3222 player) {
        return ((ServerPlayerBridge) player).colonel$knownArguments();
    }
}
