/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.stylecheck;

import ca.stellardrift.stylecheck.Utils;
import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.checks.javadoc.WriteTagCheck;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@StatelessCheck
public class FilteringWriteTag
extends WriteTagCheck {
    private static final Set<String> DEFAULT_IGNORES = Stream.of("Override", "Test").collect(Collectors.toSet());
    private boolean ignoredAnnotationsInitialized = false;
    private final List<String> ignoredAnnotations = new ArrayList<String>();
    private Scope minimumScope = Scope.PROTECTED;

    public void setIgnoredAnnotations(String ... ignoreAnnotations) {
        Objects.requireNonNull(ignoreAnnotations);
        this.ignoredAnnotationsInitialized = true;
        this.ignoredAnnotations.addAll(Arrays.asList(ignoreAnnotations));
    }

    public void setMinimumScope(Scope scope) {
        Objects.requireNonNull(scope);
        this.minimumScope = scope;
    }

    public void init() {
        super.init();
        if (!this.ignoredAnnotationsInitialized) {
            this.ignoredAnnotations.addAll(DEFAULT_IGNORES);
        }
    }

    protected String getMessageBundle() {
        return Utils.getSuperclassBundle(((Object)((Object)this)).getClass());
    }

    public void visitToken(DetailAST ast) {
        Scope surrounding;
        if (AnnotationUtil.containsAnnotation((DetailAST)ast, this.ignoredAnnotations)) {
            return;
        }
        Scope scope = ScopeUtil.getScopeFromMods((DetailAST)ast.findFirstToken(5));
        if (scope == Scope.PACKAGE && ScopeUtil.isInInterfaceOrAnnotationBlock((DetailAST)ast)) {
            scope = Scope.PUBLIC;
        }
        if ((surrounding = ScopeUtil.getSurroundingScope((DetailAST)ast)) != null && !surrounding.isIn(scope)) {
            scope = surrounding;
        }
        if (scope.compareTo((Enum)this.minimumScope) > 0) {
            return;
        }
        super.visitToken(ast);
    }
}

