/*
 * Decompiled with CFR 0.152.
 */
package ca.stellardrift.stylecheck;

import ca.stellardrift.stylecheck.VisibleElement;
import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@StatelessCheck
public class RequireExplicitVisibilityModifier
extends AbstractCheck {
    private static final int[] VISIBILITY_MODIFIERS = new int[]{62, 61, 63};
    private static final String LITERAL_PACKAGE = "package";
    private final Set<VisibleElement> checkedElementTypes = EnumSet.noneOf(VisibleElement.class);
    private boolean anchoredToBeginning = false;

    public int[] getDefaultTokens() {
        return new int[]{5};
    }

    public int[] getAcceptableTokens() {
        return new int[]{5};
    }

    public int[] getRequiredTokens() {
        return new int[]{5};
    }

    public boolean isCommentNodesRequired() {
        return true;
    }

    public void setCheckedElementTypes(String ... tokenNames) {
        for (String elementType : tokenNames) {
            this.checkedElementTypes.add(VisibleElement.valueOf(elementType));
        }
    }

    public void setAnchoredToBeginning(boolean anchoredToBeginning) {
        this.anchoredToBeginning = anchoredToBeginning;
    }

    public void init() {
        if (this.checkedElementTypes.isEmpty()) {
            Collections.addAll(this.checkedElementTypes, VisibleElement.values());
        }
    }

    public void visitToken(DetailAST ast) {
        DetailAST parent = ast.getParent();
        if (parent == null) {
            return;
        }
        VisibleElement parentType = this.matchElement(parent);
        if (parentType == null || this.isInterfaceElement(parent)) {
            return;
        }
        if (ast.getFirstChild() == null && ast.getNextSibling() != null && this.isPackageVisibilityComment(ast.getNextSibling(), false)) {
            return;
        }
        boolean visibilityFound = false;
        DetailAST nonFirstFound = null;
        for (DetailAST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Arrays.binarySearch(VISIBILITY_MODIFIERS, child.getType()) >= 0 || this.isPackageVisibilityComment(child, false)) {
                if (visibilityFound) {
                    this.log(child, "visibility.duplicate-modifier", new Object[0]);
                }
                visibilityFound = true;
                continue;
            }
            if (!this.anchoredToBeginning || visibilityFound || nonFirstFound != null || child.getType() == 159 || TokenUtil.isCommentType((int)child.getType())) continue;
            nonFirstFound = child;
        }
        if (!visibilityFound) {
            if (ast.getNextSibling() != null && (this.isPackageVisibilityComment(ast.getNextSibling(), true) || this.isPackageVisibilityComment(ast.getNextSibling().getFirstChild(), true))) {
                return;
            }
            this.log(ast, "visibility.no-modifier", new Object[0]);
        } else if (nonFirstFound != null) {
            this.log(nonFirstFound, "visibility.not-first", new Object[]{nonFirstFound.getText()});
        }
    }

    private @Nullable VisibleElement matchElement(@NonNull DetailAST parent) {
        for (VisibleElement element : this.checkedElementTypes) {
            if (!element.test(parent)) continue;
            return element;
        }
        return null;
    }

    private boolean isInterfaceElement(@NonNull DetailAST parent) {
        while ((parent = parent.getParent()) != null) {
            if (!VisibleElement.CLASS.test(parent)) continue;
            return parent.getType() == 15;
        }
        return false;
    }

    private boolean isPackageVisibilityComment(@Nullable DetailAST start, boolean siblings) {
        while (start != null && start.getType() == 145) {
            DetailAST next = start.getFirstChild();
            if (next != null && next.getType() == 183 && next.getText().trim().equals(LITERAL_PACKAGE)) {
                DetailAST end = next.getNextSibling();
                return end != null && end.getType() == 182;
            }
            start = siblings ? start.getNextSibling() : null;
        }
        return false;
    }

    static {
        Arrays.sort(VISIBILITY_MODIFIERS);
    }
}

