package ca.uhn.fhir.rest.gclient;

/*
 * #%L
 * HAPI FHIR Library
 * %%
 * Copyright (C) 2014 University Health Network
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import ca.uhn.fhir.rest.server.Constants;

public class StringParam implements IParam {

	private String myParamName;

	public StringParam(String theParamName) {
		myParamName = theParamName;
	}

	/**
	 * The string matches exactly the given value
	 */
	public IStringMatch matchesExactly() {
		return new StringExactly();
	}

	/**
	 * The string matches the given value (servers will often, but are not required to) implement this 
	 * as a left match, meaning that a value of "smi" would match "smi" and "smith".
	 */
	public IStringMatch matches() {
		return new StringMatches();
	}

	@Override
	public String getParamName() {
		return myParamName;
	}

	public interface IStringMatch {

		ICriterion value(String theValue);

	}

	private class StringExactly implements IStringMatch {
		@Override
		public ICriterion value(String theValue) {
			return new StringCriterion(getParamName() + Constants.PARAMNAME_SUFFIX_EXACT, theValue);
		}
	}

	private class StringMatches implements IStringMatch {
		@Override
		public ICriterion value(String theValue) {
			return new StringCriterion(getParamName(), theValue);
		}
	}

}
