package ca.uhn.fhir.rest.server.exceptions;

import ca.uhn.fhir.rest.server.Constants;

/*
 * #%L
 * HAPI FHIR Library
 * %%
 * Copyright (C) 2014 University Health Network
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/**
 * Represents an <b>HTTP 500 Internal Error</b> response.
 * This status indicates that the server failed to successfully process the
 * request. This generally means that the server is misbehaving or is
 * misconfigured in some way, although a misbehaving server might also
 * send this status code in the case of a bad request message (although it
 * should not do this; an HTTP 4xx response is more appropriate in that
 * situation).
 * 
 * <p>
 * Note that a complete list of RESTful exceptions is available in the
 * <a href="./package-summary.html">Package Summary</a>.
 * </p>
 * 
 * @see UnprocessableEntityException Which should be used for business level validation failures
 */
public class InternalErrorException extends BaseServerResponseException {

	public static final int STATUS_CODE = Constants.STATUS_HTTP_500_INTERNAL_ERROR;
	
	private static final long serialVersionUID = 1L;

	public InternalErrorException(String theMessage) {
		super(STATUS_CODE, theMessage);
	}

	public InternalErrorException(String theMessage, Throwable theCause) {
		super(STATUS_CODE, theMessage, theCause);
	}

	public InternalErrorException(Throwable theCause) {
		super(STATUS_CODE, theCause);
	}

}
